/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

@SpecialMob
public class FrozenSlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FrozenSlimeEntity> SPECIES;
    private byte frostWalking;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7760828).theme(BestiaryInfo.Theme.ICE).uniqueTextureBaseOnly().addExperience(1).effectImmune(MobEffects.f_19597_).addToAttribute(Attributes.f_22284_, 10.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Frozen Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FrozenSlimeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Blocks.f_50126_);
        loot.addRareDrop("rare", new ItemLike[]{Blocks.f_50568_});
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.SLIMES, EntityTypeTags.f_144294_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<FrozenSlimeEntity> getVariantFactory() {
        return FrozenSlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FrozenSlimeEntity> getSpecies() {
        return SPECIES;
    }

    public FrozenSlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    @Override
    public void m_7839_(int size, boolean resetHealth) {
        super.m_7839_(size, resetHealth);
        this.frostWalking = (byte)-1;
        while (size > 0) {
            size >>= 1;
            this.frostWalking = (byte)(this.frostWalking + 1);
        }
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.f_21345_, 1);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FluidPathNavigator((Mob)this, level, true, false);
    }

    public boolean m_203441_(FluidState fluid) {
        return fluid.m_205070_(FluidTags.f_13131_);
    }

    public void m_8119_() {
        super.m_8119_();
        MobHelper.floatInFluid((Entity)this, 0.06, (FluidType)ForgeMod.WATER_TYPE.get());
        MobHelper.hopOnFluid((Entity)this);
    }

    protected void m_5806_(BlockPos pos) {
        super.m_5806_(pos);
        MobHelper.updateFrostWalker((LivingEntity)this, pos, this.frostWalking);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19597_, 4, 0.5f);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    protected ParticleOptions m_6300_() {
        return ParticleTypes.f_123754_;
    }
}

