/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class LemonSlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<LemonSlimeEntity> SPECIES;
    private static final ParticleOptions JUMP_PARTICLE;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(15132769).theme(BestiaryInfo.Theme.STORM).uniqueTextureBaseOnly().addExperience(2).fireImmune().addToAttribute(Attributes.f_22276_, 4.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Lemon Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        LemonSlimeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42451_, 1);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42539_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<LemonSlimeEntity> getVariantFactory() {
        return LemonSlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends LemonSlimeEntity> getSpecies() {
        return SPECIES;
    }

    public LemonSlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        ExplosionHelper.spawnLightning(this.m_9236_(), target.m_20185_(), target.m_20186_(), target.m_20189_());
        float forwardPower = 1.1f;
        float upwardPower = 1.0f;
        Vec3 vKnockback = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_()).m_82541_().m_82490_((double)-1.1f).m_82549_(this.m_20184_().m_82490_((double)0.2f));
        this.m_20334_(vKnockback.f_82479_, 0.4, vKnockback.f_82481_);
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
    }

    protected ParticleOptions m_6300_() {
        return JUMP_PARTICLE;
    }

    static {
        JUMP_PARTICLE = new ItemParticleOption(ParticleTypes.f_123752_, Items.f_42539_.m_7968_());
    }
}

