/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.value.RegistryEntryList;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.species.PotionSlimeSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

@SpecialMob
public class PotionSlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<PotionSlimeEntity> SPECIES;
    private static final EntityDataAccessor<Integer> COLOR;
    private static final int EMPTY_POTION_COLOR = 3694022;
    private MobEffect potionEffect;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(11093797).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithOverlay().addExperience(2).addToAttribute(Attributes.f_22276_, 2.0).multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new PotionSlimeSpeciesConfig(manager, species);
    }

    public PotionSlimeSpeciesConfig getConfig() {
        return (PotionSlimeSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Potion Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        PotionSlimeEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43615_), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43582_), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43584_), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43593_));
        loot.addRareDrop("rare", PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43617_), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43583_), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43586_), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)Potions.f_43582_));
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<PotionSlimeEntity> getVariantFactory() {
        return PotionSlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends PotionSlimeEntity> getSpecies() {
        return SPECIES;
    }

    public PotionSlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, Level level) {
        super(entityType, level);
        this.setRandomPotionFill();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)3694022);
    }

    private void setRandomPotionFill() {
        Set allowedPotions = ((RegistryEntryList)this.getConfig().POTION.allowedPotions.get()).getEntries();
        if (allowedPotions.size() > 0) {
            ArrayList effects = new ArrayList(allowedPotions);
            if (!Config.MAIN.GENERAL.enableNausea.get()) {
                effects.remove(MobEffects.f_19604_);
            }
            if (effects.size() > 0) {
                this.setPotionFill((MobEffect)effects.get(this.f_19796_.m_188503_(effects.size())));
                return;
            }
        }
        this.setPotionFill(null);
    }

    private void setPotionFill(@Nullable MobEffect effect) {
        this.potionEffect = effect;
        this.f_19804_.m_135381_(COLOR, (Object)(effect == null ? 3694022 : effect.m_19484_()));
    }

    public int getPotionColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (this.potionEffect == null) {
            target.m_20095_();
        } else {
            MobHelper.applyEffect(target, this.potionEffect);
        }
    }

    protected boolean spawnCustomParticles() {
        int color = this.getPotionColor();
        float r = References.getRed(color);
        float g = References.getGreen(color);
        float b = References.getBlue(color);
        int size = this.m_33632_();
        for (int i = 0; i < size * 8; ++i) {
            float angle = this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
            float distance = (this.f_19796_.m_188501_() * 0.25f + 0.25f) * (float)size;
            this.m_9236_().m_7106_(this.m_6300_(), this.m_20185_() + (double)(Mth.m_14031_((float)angle) * distance), this.m_20186_(), this.m_20189_() + (double)(Mth.m_14089_((float)angle) * distance), (double)r, (double)g, (double)b);
        }
        return true;
    }

    protected ParticleOptions m_6300_() {
        return ParticleTypes.f_123811_;
    }

    @Override
    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL && super.m_7301_(effect);
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128359_("Ammo", SpecialMobs.toString(ForgeRegistries.MOB_EFFECTS.getKey((Object)this.potionEffect)));
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Ammo", References.NBT_TYPE_STRING)) {
            this.setPotionFill((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(saveTag.m_128461_("Ammo"))));
        }
    }

    static {
        COLOR = SynchedEntityData.m_135353_(PotionSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

