/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

@SpecialMob
public class StrawberrySlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<StrawberrySlimeEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(12478827).theme(BestiaryInfo.Theme.FIRE).uniqueTextureBaseOnly().addExperience(1).fireImmune().waterSensitive();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Strawberry Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        StrawberrySlimeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42613_, 1);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42497_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<StrawberrySlimeEntity> getVariantFactory() {
        return StrawberrySlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends StrawberrySlimeEntity> getSpecies() {
        return SPECIES;
    }

    public StrawberrySlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.LAVA, BlockPathTypes.WALKABLE.m_77124_());
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.m_20254_(this.m_33632_() * 3);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.f_21345_, 1);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FluidPathNavigator((Mob)this, level, false, true);
    }

    public boolean m_203441_(FluidState fluid) {
        return fluid.m_205070_(FluidTags.f_13132_);
    }

    public void m_8119_() {
        super.m_8119_();
        MobHelper.floatInFluid((Entity)this, 0.05, (FluidType)ForgeMod.LAVA_TYPE.get());
        MobHelper.hopOntoShore((Entity)this, (TagKey<Fluid>)FluidTags.f_13132_);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        this.m_21441_(BlockPathTypes.LAVA, BlockPathTypes.WALKABLE.m_77124_());
    }

    protected ParticleOptions m_6300_() {
        return ParticleTypes.f_123744_;
    }
}

