/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.MotherSpiderSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.spider.BabySpiderEntity;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

@SpecialMob
public class MotherSpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<MotherSpiderEntity> SPECIES;
    private int babies;
    private int extraBabies;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xB300B3).uniqueTextureWithEyes().size(1.2f, 1.7f, 1.0f).addExperience(1).regen(30).addToAttribute(Attributes.f_22276_, 16.0).addToAttribute(Attributes.f_22284_, 6.0).addToAttribute(Attributes.f_22281_, 3.0).addToRangedDamage(1.5);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new MotherSpiderSpeciesConfig(manager, species, 0.1, 2, 4, 3, 6);
    }

    @Override
    public MotherSpiderSpeciesConfig getConfig() {
        return (MotherSpiderSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Mother Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        MotherSpiderEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42645_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<MotherSpiderEntity> getVariantFactory() {
        return MotherSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends MotherSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public MotherSpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, Level level) {
        super(entityType, level);
        this.babies = this.getConfig().MOTHER.babies.next(this.f_19796_);
        this.extraBabies = this.getConfig().MOTHER.extraBabies.next(this.f_19796_);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            if (this.extraBabies > 0 && amount > 1.0f && this.m_9236_() instanceof ServerLevelAccessor && this.f_19796_.m_188501_() < 0.33f) {
                --this.extraBabies;
                this.spawnBaby(0.66f, null);
                this.m_21373_();
                this.m_5496_(SoundEvents.f_11877_, 1.0f, 2.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
            }
            return true;
        }
        return false;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (this.m_21224_() && !this.m_213877_() && this.m_9236_() instanceof ServerLevelAccessor) {
            int babiesToSpawn = this.babies + this.extraBabies;
            SpawnGroupData groupData = null;
            for (int i = 0; i < babiesToSpawn; ++i) {
                groupData = this.spawnBaby(0.33f, groupData);
            }
            this.m_21373_();
            this.m_5496_(SoundEvents.f_11877_, 1.0f, 2.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        }
        super.m_142687_(removalReason);
    }

    @Nullable
    private SpawnGroupData spawnBaby(float speed, @Nullable SpawnGroupData groupData) {
        BabySpiderEntity baby = (BabySpiderEntity)((EntityType)BabySpiderEntity.SPECIES.entityType.get()).m_20615_(this.m_9236_());
        if (baby == null) {
            return groupData;
        }
        baby.m_20359_((Entity)this);
        baby.f_20885_ = this.m_146908_();
        baby.f_20883_ = this.m_146908_();
        groupData = ForgeEventFactory.onFinalizeSpawn((Mob)baby, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)groupData, null);
        baby.m_6710_(this.m_5448_());
        baby.m_20334_((this.f_19796_.m_188500_() - 0.5) * (double)speed, 0.2 + 0.5 * this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * (double)speed);
        baby.m_6853_(false);
        this.m_9236_().m_7967_((Entity)baby);
        return groupData;
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("Babies", (byte)this.babies);
        saveTag.m_128344_("ExtraBabies", (byte)this.extraBabies);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Babies", 99)) {
            this.babies = saveTag.m_128445_("Babies");
        }
        if (saveTag.m_128425_("ExtraBabies", 99)) {
            this.extraBabies = saveTag.m_128445_("ExtraBabies");
        }
    }
}

