/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class PoisonSpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<PoisonSpiderEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(803406).theme(BestiaryInfo.Theme.FOREST).modBaseTexture("textures/entity/cave_spider/base_cave_spider.png").modEyesTexture("textures/entity/cave_spider/base_cave_spider_eyes.png").addExperience(1);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Venomous Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        PoisonSpiderEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42591_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<PoisonSpiderEntity> getVariantFactory() {
        return PoisonSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends PoisonSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public PoisonSpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19614_);
    }
}

