/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class DominationWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DominationWitchEntity> SPECIES;
    private static final Collection<MobEffectInstance> LEVITATION_EFFECTS;
    private int pullDelay;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16775294).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureBaseOnly().addExperience(2).multiplyAttribute(Attributes.f_22279_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch of Domination", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DominationWitchEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42612_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<DominationWitchEntity> getVariantFactory() {
        return DominationWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DominationWitchEntity> getSpecies() {
        return SPECIES;
    }

    public DominationWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (!target.m_21023_(MobEffects.f_19613_)) {
            return this.makeSplashPotion(Potions.f_43593_);
        }
        if (distance > 5.0f && !target.m_21023_(MobEffects.f_19620_) && this.f_19796_.m_188501_() < 0.5f) {
            return this.makeSplashPotion(LEVITATION_EFFECTS);
        }
        return originalPotion;
    }

    @Override
    public void m_8107_() {
        double distanceSq;
        LivingEntity target = this.m_5448_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.pullDelay-- <= 0 && target != null && this.f_19796_.m_188503_(20) == 0 && (distanceSq = target.m_20280_((Entity)this)) > 100.0 && distanceSq < 196.0 && (target.m_21023_(MobEffects.f_19613_) || target.m_21023_(MobEffects.f_19620_)) && this.m_142582_((Entity)target)) {
            this.pullDelay = 100;
            this.m_5496_(SoundEvents.f_11939_, 1.0f, 0.4f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
            MobHelper.pull((Entity)this, (Entity)target, 0.32);
        }
        super.m_8107_();
    }

    static {
        LEVITATION_EFFECTS = Collections.singletonList(new MobEffectInstance(MobEffects.f_19620_, 140, 0));
    }
}

