/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.UndeadWitchSpeciesConfig;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

@SpecialMob
public class UndeadWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<UndeadWitchEntity> SPECIES;
    private int summons;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7969893).uniqueTextureBaseOnly().addExperience(2).undead();
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new UndeadWitchSpeciesConfig(manager, species, 3, 6);
    }

    public UndeadWitchSpeciesConfig getConfig() {
        return (UndeadWitchSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Lich", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        UndeadWitchEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.f_20501_.m_20677_());
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42642_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<UndeadWitchEntity> getVariantFactory() {
        return UndeadWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends UndeadWitchEntity> getSpecies() {
        return SPECIES;
    }

    public UndeadWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, Level level) {
        super(entityType, level);
        this.summons = this.getConfig().UNDEAD.summons.next(this.f_19796_);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (this.summons > 0) {
            float f = this.f_19796_.m_188501_();
            float f2 = this.isNearSkeletons() ? 0.25f : 0.75f;
            if (f < f2) {
                --this.summons;
                _SpecialSkeletonEntity skeleton = (_SpecialSkeletonEntity)((EntityType)_SpecialSkeletonEntity.SPECIES.entityType.get()).m_20615_(this.m_9236_());
                if (skeleton != null) {
                    skeleton.m_20359_((Entity)this);
                    skeleton.f_20885_ = this.m_146908_();
                    skeleton.f_20883_ = this.m_146908_();
                    ForgeEventFactory.onFinalizeSpawn((Mob)skeleton, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                    skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
                    skeleton.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42464_));
                    skeleton.m_6710_(this.m_5448_());
                    double vX = target.m_20185_() - this.m_20185_();
                    double vZ = target.m_20189_() - this.m_20189_();
                    double vH = Math.sqrt(vX * vX + vZ * vZ);
                    skeleton.m_20334_(vX / vH * 0.7 + this.m_20184_().f_82479_ * 0.2, 0.4, vZ / vH * 0.7 + this.m_20184_().f_82481_ * 0.2);
                    skeleton.m_6853_(false);
                    this.m_9236_().m_7967_((Entity)skeleton);
                    this.m_5496_(SoundEvents.f_11705_, 1.0f, 2.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
                    skeleton.m_21373_();
                    return ItemStack.f_41583_;
                }
            }
        }
        return this.f_19796_.m_188501_() < 0.2f ? this.makeLingeringPotion(Potions.f_43582_) : this.makeSplashPotion(Potions.f_43582_);
    }

    private boolean isNearSkeletons() {
        return this.m_9236_().m_45976_(AbstractSkeleton.class, this.m_20191_().m_82400_(11.0)).size() > 0;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("Summons", (byte)this.summons);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Summons", 99)) {
            this.summons = saveTag.m_128445_("Summons");
        }
    }
}

