/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.WitchFamilyConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.WildsWitchSpeciesConfig;
import fathertoast.specialmobs.common.entity.spider.BabySpiderEntity;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

@SpecialMob
public class WildsWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WildsWitchEntity> SPECIES;
    private int spiderMounts;
    private int spiderSwarms;
    private int spiderSwarmSize;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(11013646).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(1).spider().multiplyAttribute(Attributes.f_22279_, 0.7);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new WildsWitchSpeciesConfig(manager, species, 1, 3, 3, 6, 3, 4);
    }

    public WildsWitchSpeciesConfig getConfig() {
        return (WildsWitchSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch of the Wilds", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WildsWitchEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42645_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<WildsWitchEntity> getVariantFactory() {
        return WildsWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WildsWitchEntity> getSpecies() {
        return SPECIES;
    }

    public WildsWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, Level level) {
        super(entityType, level);
        this.spiderMounts = this.getConfig().WILDS.mounts.next(this.f_19796_);
        this.spiderSwarms = this.getConfig().WILDS.swarms.next(this.f_19796_);
        this.spiderSwarmSize = this.getConfig().WILDS.swarmSize.next(this.f_19796_);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (this.spiderSwarms > 0 && this.f_19796_.m_188501_() < 0.33f) {
            --this.spiderSwarms;
            SpawnGroupData groupData = null;
            for (int i = 0; i < this.spiderSwarmSize; ++i) {
                groupData = this.spawnBaby(groupData);
            }
            this.m_21373_();
            this.m_5496_(SoundEvents.f_11877_, 1.0f, 2.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
            return ItemStack.f_41583_;
        }
        if (!target.m_21023_(MobEffects.f_19614_)) {
            return this.makeSplashPotion(Potions.f_43586_);
        }
        Potion originalType = PotionUtils.m_43579_((ItemStack)originalPotion);
        if (originalType == Potions.f_43582_ || originalType == Potions.f_43583_) {
            return this.makeSplashPotion(Potions.f_43586_);
        }
        return originalPotion;
    }

    @Nullable
    private SpawnGroupData spawnBaby(@Nullable SpawnGroupData groupData) {
        BabySpiderEntity baby = (BabySpiderEntity)((EntityType)BabySpiderEntity.SPECIES.entityType.get()).m_20615_(this.m_9236_());
        if (baby == null) {
            return groupData;
        }
        baby.m_20359_((Entity)this);
        baby.f_20885_ = this.m_146908_();
        baby.f_20883_ = this.m_146908_();
        groupData = ForgeEventFactory.onFinalizeSpawn((Mob)baby, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)groupData, null);
        baby.m_6710_(this.m_5448_());
        baby.m_20334_((this.f_19796_.m_188500_() - 0.5) * 0.33, this.f_19796_.m_188500_() * 0.5, (this.f_19796_.m_188500_() - 0.5) * 0.33);
        baby.m_6853_(false);
        this.m_9236_().m_7967_((Entity)baby);
        return groupData;
    }

    @Override
    protected void tryVariantUsingPotion() {
        _SpecialSpiderEntity spider;
        LivingEntity mount;
        LivingEntity livingEntity = mount = this.m_20202_() instanceof LivingEntity ? (LivingEntity)this.m_20202_() : null;
        if (mount != null && this.f_19796_.m_188501_() < 0.15f && mount.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !mount.m_21023_(MobEffects.f_19608_)) {
            this.usePotion(this.makeSplashPotion(Potions.f_43621_));
        } else if (mount != null && this.f_19796_.m_188501_() < 0.15f && (mount.m_6060_() || mount.m_21225_() != null && mount.m_21225_().m_269533_(DamageTypeTags.f_268745_)) && !this.m_21023_(MobEffects.f_19607_)) {
            this.usePotion(this.makeSplashPotion(Potions.f_43610_));
        } else if (mount != null && this.f_19796_.m_188501_() < 0.05f && mount.m_6336_() != MobType.f_21641_ && mount.m_21223_() < mount.m_21233_()) {
            this.usePotion(this.makeSplashPotion(Potions.f_43623_));
        } else if (!((WitchFamilyConfig)((Object)MobFamily.WITCH.config)).WITCHES.useSplashSwiftness.get() && mount != null && this.f_19796_.m_188501_() < 0.5f && this.m_5448_() != null && !mount.m_21023_(MobEffects.f_19596_) && this.m_5448_().m_20280_((Entity)this) > 121.0) {
            this.usePotion(this.makeSplashPotion(Potions.f_43612_));
        } else if (this.spiderMounts > 0 && this.f_19796_.m_188501_() < 0.15f && this.m_20202_() == null && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) > 100.0 && (spider = (_SpecialSpiderEntity)((EntityType)_SpecialSpiderEntity.SPECIES.entityType.get()).m_20615_(this.m_9236_())) != null) {
            spider.m_20359_((Entity)this);
            spider.f_20885_ = this.m_146908_();
            spider.f_20883_ = this.m_146908_();
            if (this.m_9236_().m_45772_(spider.m_20191_())) {
                --this.spiderMounts;
                this.potionUseCooldownTimer = 40;
                spider.m_6710_(this.m_5448_());
                ForgeEventFactory.onFinalizeSpawn((Mob)spider, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                this.m_9236_().m_7967_((Entity)spider);
                spider.m_21373_();
                this.m_5496_(SoundEvents.f_11705_, 1.0f, 2.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
                this.m_7998_((Entity)spider, true);
            } else {
                spider.m_146870_();
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("Summons", (byte)this.spiderMounts);
        saveTag.m_128344_("Babies", (byte)this.spiderSwarms);
        saveTag.m_128344_("ExtraBabies", (byte)this.spiderSwarmSize);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Summons", 99)) {
            this.spiderMounts = saveTag.m_128445_("Summons");
        }
        if (saveTag.m_128425_("Babies", 99)) {
            this.spiderSwarms = saveTag.m_128445_("Babies");
        }
        if (saveTag.m_128425_("ExtraBabies", 99)) {
            this.spiderSwarmSize = saveTag.m_128445_("ExtraBabies");
        }
    }
}

