/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.WitchFamilyConfig;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class _SpecialWitchEntity
extends Witch
implements ISpecialMob<_SpecialWitchEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialWitchEntity> SPECIES;
    private static final AttributeModifier DRINKING_SPEED_PENALTY;
    private static final EntityDataAccessor<Float> SCALE;
    private boolean fakeDrinkingPotion;
    protected int potionDrinkTimer;
    protected int potionUseCooldownTimer;
    public ItemStack sheathedItem = ItemStack.f_41583_;
    private SpecialMobData<_SpecialWitchEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(5349438).modBaseTexture("textures/entity/witch/base_witch.png").experience(5).throwAttack(1.0, 1.0, 60, 10.0);
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_34155_() {
        return Witch.m_34155_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialWitchEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch", "Bruja", "Bruxa", "Sorci\u00e8re", "Strega", "Hexe", "Wizard");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20495_.m_20677_());
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(EntityTypeTags.f_13121_, SMTags.EntityTypes.WITCHES);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<_SpecialWitchEntity> getFactory() {
        return _SpecialWitchEntity::new;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
    }

    public void m_19970_(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.m_19970_(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void m_6504_(LivingEntity target, float damageMulti) {
        if (this.m_34161_()) {
            return;
        }
        Vec3 vTarget = target.m_20184_();
        double dX = target.m_20185_() + vTarget.f_82479_ - this.m_20185_();
        double dY = target.m_20188_() - 1.1 - this.m_20186_();
        double dZ = target.m_20189_() + vTarget.f_82481_ - this.m_20189_();
        float dH = Mth.m_14116_((float)((float)(dX * dX + dZ * dZ)));
        ItemStack potion = this.pickThrownPotion(target, damageMulti, dH);
        if (potion.m_41619_()) {
            return;
        }
        ThrownPotion thrownPotion = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
        thrownPotion.m_37446_(potion);
        thrownPotion.m_146926_(thrownPotion.m_146909_() + 20.0f);
        thrownPotion.m_6686_(dX, dY + (double)(dH * 0.2f), dZ, 0.75f, 8.0f * this.getSpecialData().getRangedAttackSpread());
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
        this.m_9236_().m_7967_((Entity)thrownPotion);
    }

    protected ItemStack pickThrownPotion(LivingEntity target, float damageMulti, float distance) {
        if (target instanceof Raider) {
            ItemStack potion = target.m_6336_() == MobType.f_21641_ ? this.makeSplashPotion(Potions.f_43582_) : (target.m_21223_() <= 4.0f ? this.makeSplashPotion(Potions.f_43623_) : this.makeSplashPotion(Potions.f_43587_));
            this.m_6710_(null);
            return this.pickVariantSupportPotion(potion, (Raider)target, distance);
        }
        ItemStack potion = distance >= 8.0f && !target.m_21023_(MobEffects.f_19597_) ? this.makeSplashPotion(Potions.f_43615_) : (target.m_21223_() >= 8.0f && !target.m_21023_(MobEffects.f_19614_) ? this.makeSplashPotion(Potions.f_43584_) : (distance <= 3.0f && !target.m_21023_(MobEffects.f_19613_) && this.f_19796_.m_188501_() < 0.25f ? this.makeSplashPotion(Potions.f_43593_) : (target.m_6336_() == MobType.f_21641_ ? this.makeSplashPotion(Potions.f_43623_) : this.makeSplashPotion(Potions.f_43582_))));
        return this.pickVariantThrownPotion(potion, target, damageMulti, distance);
    }

    protected ItemStack pickVariantSupportPotion(ItemStack originalPotion, Raider target, float distance) {
        return originalPotion;
    }

    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        return originalPotion;
    }

    protected void tryUsingPotion() {
        if (this.f_19796_.m_188501_() < 0.15f && this.m_204029_(FluidTags.f_13131_) && !this.m_21023_(MobEffects.f_19608_)) {
            this.usePotion(this.makePotion(Potions.f_43621_));
        } else if (this.f_19796_.m_188501_() < 0.15f && (this.m_6060_() || this.m_21225_() != null && this.m_21225_().m_269533_(DamageTypeTags.f_268745_)) && !this.m_21023_(MobEffects.f_19607_)) {
            this.usePotion(this.makePotion(Potions.f_43610_));
        } else if (this.f_19796_.m_188501_() < 0.05f && this.m_21223_() < this.m_21233_()) {
            this.usePotion(this.makePotion(this.m_6336_() == MobType.f_21641_ ? Potions.f_43582_ : Potions.f_43623_));
        } else if (this.f_19796_.m_188501_() < 0.5f && this.m_5448_() != null && !this.m_21023_(MobEffects.f_19596_) && this.m_5448_().m_20280_((Entity)this) > 121.0) {
            this.usePotion(((WitchFamilyConfig)((Object)MobFamily.WITCH.config)).WITCHES.useSplashSwiftness.get() ? this.makeSplashPotion(Potions.f_43612_) : this.makePotion(Potions.f_43612_));
        } else {
            this.tryVariantUsingPotion();
        }
    }

    protected void tryVariantUsingPotion() {
    }

    public void addVariantSaveData(CompoundTag saveTag) {
    }

    public void readVariantSaveData(CompoundTag saveTag) {
    }

    public _SpecialWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, Level level) {
        super(entityType, level);
        this.f_34129_ = Integer.MAX_VALUE;
        this.recalculateAttackGoal();
        this.getSpecialData().initialize();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.specialData = new SpecialMobData<_SpecialWitchEntity>(this, SCALE);
    }

    public void recalculateAttackGoal() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            AIHelper.removeGoals(this.f_21345_, RangedAttackGoal.class);
            this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, (double)this.getSpecialData().getRangedWalkSpeed(), this.getSpecialData().getRangedAttackCooldown(), this.getSpecialData().getRangedAttackMaxRange()));
        }
    }

    public void drinkPotionUpdate() {
        --this.potionUseCooldownTimer;
        if (this.m_34161_()) {
            if (this.potionDrinkTimer-- <= 0) {
                ItemStack drinkingItem = this.m_21205_();
                this.usePotion(ItemStack.f_41583_);
                if (drinkingItem.m_41720_() == Items.f_42589_) {
                    List effects = PotionUtils.m_43547_((ItemStack)drinkingItem);
                    for (MobEffectInstance effect : effects) {
                        this.m_7292_(new MobEffectInstance(effect));
                    }
                }
            }
        } else if (this.potionUseCooldownTimer <= 0) {
            this.tryUsingPotion();
        }
    }

    public void usePotion(ItemStack potion) {
        if (this.m_34161_() && !potion.m_41619_()) {
            this.usePotion(ItemStack.f_41583_);
        }
        if (potion.m_41619_()) {
            if (this.m_34161_()) {
                this.m_34163_(false);
                this.potionDrinkTimer = 0;
                AttributeInstance attribute = this.m_21051_(Attributes.f_22279_);
                if (attribute != null) {
                    attribute.m_22130_(DRINKING_SPEED_PENALTY);
                }
                this.m_8061_(EquipmentSlot.MAINHAND, this.sheathedItem);
                this.sheathedItem = ItemStack.f_41583_;
            }
        } else if (potion.m_41720_() == Items.f_42589_) {
            AttributeInstance attribute;
            this.sheathedItem = this.m_21205_();
            this.m_8061_(EquipmentSlot.MAINHAND, potion);
            this.m_34163_(true);
            this.potionDrinkTimer = this.m_21205_().m_41779_();
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12551_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            if ((attribute = this.m_21051_(Attributes.f_22279_)) != null) {
                attribute.m_22130_(DRINKING_SPEED_PENALTY);
                attribute.m_22118_(DRINKING_SPEED_PENALTY);
            }
        } else if (potion.m_41720_() == Items.f_42736_ || potion.m_41720_() == Items.f_42739_) {
            this.potionUseCooldownTimer = 40;
            ThrownPotion thrownPotion = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
            thrownPotion.m_37446_(potion);
            thrownPotion.m_146926_(thrownPotion.m_146909_() + 20.0f);
            thrownPotion.m_6686_(0.0, -1.0, 0.0, 0.2f, 0.0f);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            this.m_9236_().m_7967_((Entity)thrownPotion);
        } else {
            SpecialMobs.LOG.warn("Witch {} attempted to use '{}' as a potion! Gross!", (Object)this.getClass().getSimpleName(), (Object)potion);
        }
    }

    public ItemStack makePotion(Potion type) {
        return this.newPotion((ItemLike)Items.f_42589_, type);
    }

    public ItemStack makePotion(Collection<MobEffectInstance> effects) {
        return this.newPotion((ItemLike)Items.f_42589_, effects);
    }

    public ItemStack makeSplashPotion(Potion type) {
        return this.newPotion((ItemLike)Items.f_42736_, type);
    }

    public ItemStack makeSplashPotion(Collection<MobEffectInstance> effects) {
        return this.newPotion((ItemLike)Items.f_42736_, effects);
    }

    public ItemStack makeLingeringPotion(Potion type) {
        return this.newPotion((ItemLike)Items.f_42739_, type);
    }

    public ItemStack makeLingeringPotion(Collection<MobEffectInstance> effects) {
        return this.newPotion((ItemLike)Items.f_42739_, effects);
    }

    private ItemStack newPotion(ItemLike item, Potion type) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack(item), (Potion)type);
    }

    private ItemStack newPotion(ItemLike item, Collection<MobEffectInstance> effects) {
        return PotionUtils.m_43552_((ItemStack)new ItemStack(item), effects);
    }

    @Override
    public SpecialMobData<_SpecialWitchEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialWitchEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.f_21364_;
    }

    @Override
    public final void setExperience(int xp) {
        this.f_21364_ = xp;
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> entityType, boolean keepEquipment) {
        Level level;
        Mob replacement = super.m_21406_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            MobHelper.finalizeSpawn((LivingEntity)replacement, serverLevel, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, level, difficulty, spawnType, super.m_6518_(level, difficulty, spawnType, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(BlockPathTypes type, float malus) {
        this.m_21441_(type, malus);
    }

    protected final void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnReason, @Nullable SpawnGroupData groupData) {
        this.finalizeVariantSpawn(level, difficulty, spawnReason, groupData);
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            this.drinkPotionUpdate();
            this.fakeDrinkingPotion = true;
        }
        super.m_8107_();
        this.getSpecialData().tick();
    }

    public boolean m_34161_() {
        if (this.fakeDrinkingPotion) {
            this.fakeDrinkingPotion = false;
            return true;
        }
        return super.m_34161_();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return super.m_6431_(pose, size) * this.getSpecialData().getHeightScaleByAge();
    }

    public boolean m_5825_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void m_7311_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.m_7311_(ticks);
        }
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.getSpecialData().allowLeashing();
    }

    public void m_7601_(BlockState block, Vec3 speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.m_7601_(block, speedMulti);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return super.m_142535_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier(), damageSource);
    }

    public boolean m_6090_() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean m_6040_() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean m_6063_() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean m_6126_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6126_() && source.m_7640_() instanceof Snowball) {
            amount = Math.max(3.0f, amount);
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        CompoundTag itemTag = new CompoundTag();
        if (!this.sheathedItem.m_41619_()) {
            this.sheathedItem.m_41739_(itemTag);
        }
        saveTag.m_128365_("SheathedItem", (Tag)itemTag);
        saveTag.m_128376_("PotionUseTimer", (short)this.potionDrinkTimer);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.m_128425_("SheathedItem", References.NBT_TYPE_COMPOUND)) {
            this.sheathedItem = ItemStack.m_41712_((CompoundTag)saveTag.m_128469_("SheathedItem"));
        }
        if (saveTag.m_128425_("PotionUseTimer", 99)) {
            this.potionDrinkTimer = saveTag.m_128448_("PotionUseTimer");
        }
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
        this.recalculateAttackGoal();
    }

    static {
        DRINKING_SPEED_PENALTY = new AttributeModifier(UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E"), "Drinking speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
        SCALE = SynchedEntityData.m_135353_(_SpecialWitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

