/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witherskeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.witherskeleton._SpecialWitherSkeletonEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class BruteWitherSkeletonEntity
extends _SpecialWitherSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<BruteWitherSkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16775294).uniqueTextureWithOverlay().size(1.44f, 0.85f, 2.9f).addExperience(2).addToAttribute(Attributes.f_22276_, 10.0).addToAttribute(Attributes.f_22284_, 10.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Wither Skeleton Brute", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        BruteWitherSkeletonEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42484_, 1);
        loot.addRareDrop("rare", new ItemLike[]{Items.f_42416_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<BruteWitherSkeletonEntity> getVariantFactory() {
        return BruteWitherSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends BruteWitherSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public BruteWitherSkeletonEntity(EntityType<? extends _SpecialWitherSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.causeLifeLoss(target, 2.0f);
        MobHelper.knockback((Entity)this, target, 2.0f, 1.0f);
    }

    @Override
    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, MobEffects.f_19602_);
    }
}

