/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witherskeleton;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.witherskeleton._SpecialWitherSkeletonEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class GatlingWitherSkeletonEntity
extends _SpecialWitherSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<GatlingWitherSkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xFFFF0B).modBaseTexture("textures/entity/wither_skeleton/base_wither_skeleton.png").uniqueOverlayTexture().addExperience(2).multiplyRangedSpread(2.0).multiplyRangedWalkSpeed(0.3).rangedCooldown(1).addToAttribute(Attributes.f_22276_, 10.0).addToAttribute(Attributes.f_22281_, 2.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(manager, species, 1.0, 0.05);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Gatling Wither Skeleton", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        GatlingWitherSkeletonEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (ItemLike)Items.f_42412_, 1);
        loot.addCommonDrop("common", (ItemLike)Items.f_42403_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<GatlingWitherSkeletonEntity> getVariantFactory() {
        return GatlingWitherSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends GatlingWitherSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public GatlingWitherSkeletonEntity(EntityType<? extends _SpecialWitherSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }
}

