/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witherskeleton;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.witherskeleton._SpecialWitherSkeletonEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class SpitfireWitherSkeletonEntity
extends _SpecialWitherSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SpitfireWitherSkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14424576).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithEyes().size(1.8f, 0.95f, 3.6f).addExperience(2).waterSensitive().rangedDamage(0.0).addToAttribute(Attributes.f_22276_, 20.0).addToAttribute(Attributes.f_22281_, 2.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(manager, species, 1.0, 0.05);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Spitfire Wither Skeleton", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SpitfireWitherSkeletonEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42613_);
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.WITHER_SKELETONS, EntityTypeTags.f_144295_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<SpitfireWitherSkeletonEntity> getVariantFactory() {
        return SpitfireWitherSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SpitfireWitherSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public SpitfireWitherSkeletonEntity(EntityType<? extends _SpecialWitherSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.m_20254_(10);
        MobHelper.knockback((Entity)this, target, 3.0f, 1.0f);
    }

    @Override
    public void m_6504_(LivingEntity target, float damageMulti) {
        References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        float accelVariance = Mth.m_14116_((float)this.m_20270_((Entity)target)) * 0.5f * this.getSpecialData().getRangedAttackSpread();
        for (int i = 0; i < 4; ++i) {
            double dX = target.m_20185_() - this.m_20185_() + this.m_217043_().m_188583_() * (double)accelVariance;
            double dY = target.m_20188_() - this.m_20188_();
            double dZ = target.m_20189_() - this.m_20189_() + this.m_217043_().m_188583_() * (double)accelVariance;
            SmallFireball fireball = new SmallFireball(this.m_9236_(), (LivingEntity)this, dX, dY, dZ);
            fireball.m_6034_(fireball.m_20185_(), this.m_20188_() - 0.1, fireball.m_20189_());
            this.m_9236_().m_7967_((Entity)fireball);
        }
    }

    @Override
    public void m_6863_(boolean value) {
    }

    @Override
    public boolean m_6162_() {
        return false;
    }
}

