/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombie;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.drowned.FrozenDrownedEntity;
import fathertoast.specialmobs.common.entity.zombie._SpecialZombieEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.UUID;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

@SpecialMob
public class FrozenZombieEntity
extends _SpecialZombieEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FrozenZombieEntity> SPECIES;
    private static final AttributeModifier BURNING_SPEED_BOOST;
    private boolean wasBurning;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).theme(BestiaryInfo.Theme.ICE).uniqueTextureBaseOnly().addExperience(1).addToAttribute(Attributes.f_22284_, 10.0).multiplyAttribute(Attributes.f_22279_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Frozen Zombie", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FrozenZombieEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (ItemLike)Items.f_42452_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Blocks.f_50126_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<FrozenZombieEntity> getVariantFactory() {
        return FrozenZombieEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FrozenZombieEntity> getSpecies() {
        return SPECIES;
    }

    public FrozenZombieEntity(EntityType<? extends _SpecialZombieEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.f_21345_, WaterAvoidingRandomStrollGoal.class);
        AIHelper.removeGoals(this.f_21345_, LookAtPlayerGoal.class);
        AIHelper.removeGoals(this.f_21345_, RandomLookAroundGoal.class);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19597_, 2);
    }

    @Override
    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, MobEffects.f_19597_);
    }

    @Override
    protected EntityType<? extends Zombie> getVariantConversionType() {
        return (EntityType)FrozenDrownedEntity.SPECIES.entityType.get();
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.wasBurning != this.m_20094_() > 0) {
            this.wasBurning = !this.wasBurning;
            AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
            attributeInstance.m_22130_(BURNING_SPEED_BOOST);
            if (this.wasBurning) {
                attributeInstance.m_22118_(BURNING_SPEED_BOOST);
            }
        }
        super.m_8107_();
    }

    static {
        BURNING_SPEED_BOOST = new AttributeModifier(UUID.fromString("B4704571-9566-4402-BC1F-2EE2A276D836"), "AHHHHHHHHHHHHHHH", 0.75, AttributeModifier.Operation.MULTIPLY_BASE);
    }
}

