/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombifiedpiglin;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.zombifiedpiglin._SpecialZombifiedPiglinEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

@SpecialMob
public class HungryZombifiedPiglinEntity
extends _SpecialZombifiedPiglinEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<HungryZombifiedPiglinEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(11212056).uniqueTextureBaseOnly().addExperience(2).regen(30).disableRangedAttack().addToAttribute(Attributes.f_22276_, 10.0).multiplyAttribute(Attributes.f_22279_, 1.3);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Hungry Zombified Piglin", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        HungryZombifiedPiglinEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42500_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42579_, Items.f_42581_, Items.f_42658_, Items.f_42485_, Items.f_42697_, Items.f_42572_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<HungryZombifiedPiglinEntity> getVariantFactory() {
        return HungryZombifiedPiglinEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends HungryZombifiedPiglinEntity> getSpecies() {
        return SPECIES;
    }

    public HungryZombifiedPiglinEntity(EntityType<? extends _SpecialZombifiedPiglinEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.m_21553_(false);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (target instanceof Player) {
            ItemStack food;
            Player player = (Player)target;
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && !(food = MobHelper.stealRandomFood(player)).m_41619_()) {
                FoodProperties foodStats = food.m_41720_().getFoodProperties(food, (LivingEntity)this);
                this.m_5634_(Math.max(foodStats == null ? 0.0f : (float)foodStats.m_38744_(), 1.0f));
                this.m_5496_(SoundEvents.f_12321_, 0.5f, this.f_19796_.m_188501_() * 0.1f + 0.9f);
                return;
            }
        }
        MobHelper.stealLife((LivingEntity)this, target, 2.0f);
    }
}

