/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombifiedpiglin;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.ZombieSpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialHurtByTargetGoal;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class _SpecialZombifiedPiglinEntity
extends ZombifiedPiglin
implements RangedAttackMob,
ISpecialMob<_SpecialZombifiedPiglinEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialZombifiedPiglinEntity> SPECIES;
    protected static final double DEFAULT_BOW_CHANCE = 0.2;
    protected static final double DEFAULT_SHIELD_CHANCE = 0.05;
    private static final EntityDataAccessor<Float> SCALE;
    private Goal currentAttackAI;
    private SpecialMobData<_SpecialZombifiedPiglinEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(5009705).modBaseTexture("textures/entity/zombified_piglin/base_zombified_piglin.png").experience(5).undead().bowAttack(2.0, 1.0, 0.8, 20, 15.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new ZombieSpeciesConfig(manager, species, 0.2, 0.05);
    }

    public ZombieSpeciesConfig getConfig() {
        return (ZombieSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_34470_() {
        return ZombifiedPiglin.m_34470_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialZombifiedPiglinEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, _SpecialZombifiedPiglinEntity::checkFamilySpawnRules);
    }

    public static boolean checkFamilySpawnRules(EntityType<? extends ZombifiedPiglin> type, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return ZombifiedPiglin.m_219173_(type, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, level, reason, pos, random);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Zombified Piglin", "Piglin zombificado", "Piglin-zombie", "Piglin zombifi\u00e9", "Piglin zombificato", "Zombifizierter Piglin", "Corpse o' Devil's Swine");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20531_.m_20677_());
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return Collections.singletonList(SMTags.EntityTypes.ZOMBIFIED_PIGLINS);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<_SpecialZombifiedPiglinEntity> getFactory() {
        return _SpecialZombifiedPiglinEntity::new;
    }

    protected void m_8099_() {
        super.m_8099_();
        AIHelper.removeGoals(this.f_21345_, ZombieAttackGoal.class);
        AIHelper.replaceHurtByTarget((PathfinderMob)this, new SpecialHurtByTargetGoal((PathfinderMob)this, ZombifiedPiglin.class, new Class[0]).setAlertOthers(new Class[0]));
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    protected int getVariantAttackPriority() {
        return 2;
    }

    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
    }

    public void m_6504_(LivingEntity target, float damageMulti) {
        ItemStack arrowItem = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow arrow = this.getArrow(arrowItem, damageMulti);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            arrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(arrow);
        }
        double dX = target.m_20185_() - this.m_20185_();
        double dY = target.m_20227_(0.3333) - arrow.m_20186_();
        double dZ = target.m_20189_() - this.m_20189_();
        double dH = Mth.m_14116_((float)((float)(dX * dX + dZ * dZ)));
        arrow.m_6686_(dX, dY + dH * 0.2, dZ, 1.6f, this.getSpecialData().getRangedAttackSpread() * (float)(14 - 4 * this.m_9236_().m_46791_().m_19028_()));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
    }

    protected AbstractArrow getArrow(ItemStack arrowItem, float damageMulti) {
        return this.getVariantArrow(ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowItem, (float)(damageMulti * this.getSpecialData().getRangedAttackDamage() / 2.0f)), arrowItem, damageMulti);
    }

    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        return arrow;
    }

    public void m_19970_(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.m_19970_(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundTag saveTag) {
    }

    public void readVariantSaveData(CompoundTag saveTag) {
    }

    public _SpecialZombifiedPiglinEntity(EntityType<? extends _SpecialZombifiedPiglinEntity> entityType, Level level) {
        super(entityType, level);
        this.reassessWeaponGoal();
        this.getSpecialData().initialize();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.specialData = new SpecialMobData<_SpecialZombifiedPiglinEntity>(this, SCALE);
    }

    public void m_8061_(EquipmentSlot slot, ItemStack item) {
        super.m_8061_(slot, item);
        if (!this.m_9236_().f_46443_) {
            this.reassessWeaponGoal();
        }
    }

    public void reassessWeaponGoal() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            if (this.currentAttackAI != null) {
                this.f_21345_.m_25363_(this.currentAttackAI);
            }
            SpecialMobData<_SpecialZombifiedPiglinEntity> data = this.getSpecialData();
            ItemStack weapon = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            this.currentAttackAI = data.getRangedAttackMaxRange() > 0.0f && weapon.m_41720_() == Items.f_42411_ ? new RangedBowAttackGoal((Monster)this, (double)data.getRangedWalkSpeed(), data.getRangedAttackCooldown(), data.getRangedAttackMaxRange()) : new ZombieAttackGoal((Zombie)this, 1.0, false);
            this.f_21345_.m_25352_(this.getVariantAttackPriority(), this.currentAttackAI);
        }
    }

    @Override
    public SpecialMobData<_SpecialZombifiedPiglinEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialZombifiedPiglinEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.f_21364_;
    }

    @Override
    public final void setExperience(int xp) {
        this.f_21364_ = xp;
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> entityType, boolean keepEquipment) {
        Level level;
        Mob replacement = super.m_21406_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            MobHelper.finalizeSpawn((LivingEntity)replacement, serverLevel, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, level, difficulty, spawnType, super.m_6518_(level, difficulty, spawnType, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(BlockPathTypes type, float malus) {
        this.m_21441_(type, malus);
    }

    protected final void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        if (this.getSpecialData().getRangedAttackMaxRange() > 0.0f && this.getConfig().ZOMBIES.bowEquipChance.rollChance(this.f_19796_)) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        } else if (this.getConfig().ZOMBIES.shieldEquipChance.rollChance(this.f_19796_)) {
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
        this.finalizeVariantSpawn(level, difficulty, spawnType, groupData);
        this.reassessWeaponGoal();
    }

    public void m_8107_() {
        super.m_8107_();
        this.getSpecialData().tick();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return super.m_6431_(pose, size) * this.getSpecialData().getHeightScale();
    }

    public boolean m_5825_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void m_7311_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.m_7311_(ticks);
        }
    }

    protected boolean m_5884_() {
        return !this.getSpecialData().isImmuneToFire() && !this.getSpecialData().isImmuneToBurning();
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.getSpecialData().allowLeashing();
    }

    public void m_7601_(BlockState block, Vec3 speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.m_7601_(block, speedMulti);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return super.m_142535_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier(), damageSource);
    }

    public boolean m_6090_() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean m_6040_() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean m_6063_() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean m_6126_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7640_();
        if (this.m_6126_() && entity instanceof Snowball) {
            amount = Math.max(3.0f, amount);
        }
        if (amount > 0.0f && MobHelper.tryBlockAttack((LivingEntity)this, source, true)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
        this.reassessWeaponGoal();
    }

    static {
        SCALE = SynchedEntityData.m_135353_(_SpecialZombifiedPiglinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

