/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.event;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;

public final class NaturalSpawnManager {
    private static SpawnPlacementRegisterEvent registerEvent = null;

    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        if (!Config.MAIN.GENERAL.enableNaturalSpawning.get()) {
            return;
        }
        registerEvent = event;
        for (MobFamily.Species<?> species : MobFamily.getAllSpecies()) {
            species.registerSpawnPlacement();
        }
        if (Config.MAIN.NATURAL_SPAWNING.caveSpiderSpawnMultiplier.get() > 0.0) {
            try {
                event.register(EntityType.f_20554_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, NaturalSpawnManager::checkSpawnRulesCaveSpider, SpawnPlacementRegisterEvent.Operation.AND);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        registerEvent = null;
    }

    public static void registerSpawnPlacement(MobFamily.Species<? extends Monster> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, SpawnPlacements.Type.ON_GROUND);
    }

    public static void registerSpawnPlacement(MobFamily.Species<? extends Monster> species, SpawnPlacements.Type type) {
        NaturalSpawnManager.registerSpawnPlacement(species, type, NaturalSpawnManager::checkSpawnRulesDefault);
    }

    public static <T extends Mob> void registerSpawnPlacement(MobFamily.Species<T> species, SpawnPlacements.SpawnPredicate<T> predicate) {
        NaturalSpawnManager.registerSpawnPlacement(species, SpawnPlacements.Type.ON_GROUND, predicate);
    }

    public static <T extends Mob> void registerSpawnPlacement(MobFamily.Species<T> species, SpawnPlacements.Type type, SpawnPlacements.SpawnPredicate<T> predicate) {
        registerEvent.register((EntityType)species.entityType.get(), type, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, SpawnPlacementRegisterEvent.Operation.AND);
    }

    public static boolean checkSpawnRulesDefault(EntityType<? extends Monster> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Monster.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, level, spawnType, pos, random);
    }

    public static boolean checkSpawnRulesIgnoreLight(EntityType<? extends Monster> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Monster.m_219019_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, level, spawnType, pos, random);
    }

    public static boolean checkSpawnRulesBasic(EntityType<? extends Mob> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, level, spawnType, pos, random);
    }

    public static boolean checkSpawnRulesWater(EntityType<? extends Mob> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.m_6425_(pos).m_205070_(FluidTags.f_13131_)) && NaturalSpawnManager.checkSpawnRulesConfigured(type, level, spawnType, pos, random);
    }

    public static boolean checkSpawnRulesConfigured(EntityType<? extends LivingEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        MobFamily.Species<? extends LivingEntity> species;
        if (spawnType == MobSpawnType.NATURAL && (species = MobFamily.Species.of(type)) != null && levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            return species.config.GENERAL.naturalSpawnChance.rollChance(random, level, pos);
        }
        return true;
    }

    public static boolean checkSpawnRulesCaveSpider(EntityType<CaveSpider> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        Level level;
        if (spawnType == MobSpawnType.NATURAL && levelAccessor instanceof Level && !Config.MAIN.NATURAL_SPAWNING.caveSpiderSpawnChance.rollChance(random, level = (Level)levelAccessor, pos)) {
            return false;
        }
        return Monster.m_219013_(type, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

