/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.util;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionHelper {
    public final Entity source;
    public final Level level;
    public final float radius;
    public final Explosion.BlockInteraction mode;
    public final ExplosionDamageCalculator damageCalculator;
    public final Explosion explosion;

    public static Explosion.BlockInteraction getMode(Entity entity) {
        return ForgeEventFactory.getMobGriefingEvent((Level)entity.m_9236_(), (Entity)entity) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
    }

    public static Explosion explode(Entity entity, float power, boolean damageBlocks, boolean fiery) {
        return ExplosionHelper.explode(entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), power, damageBlocks, fiery);
    }

    public static Explosion explode(Entity entity, double x, double y, double z, float power, boolean damageBlocks, boolean fiery) {
        Explosion.BlockInteraction explosionMode = damageBlocks ? ExplosionHelper.getMode(entity) : Explosion.BlockInteraction.KEEP;
        return entity.m_9236_().m_255391_(entity, x, y, z, power, fiery, switch (explosionMode) {
            case Explosion.BlockInteraction.KEEP -> Level.ExplosionInteraction.NONE;
            default -> Level.ExplosionInteraction.MOB;
        });
    }

    public static void spawnLightning(Level level, double x, double y, double z) {
        LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
        if (lightning != null) {
            lightning.m_6027_(x, y, z);
            level.m_7967_((Entity)lightning);
        }
    }

    public ExplosionHelper(Entity entity, float power, boolean damageBlocks, boolean fiery) {
        this(entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), power, damageBlocks, fiery);
    }

    public ExplosionHelper(Entity entity, float power, Explosion.BlockInteraction explosionMode, boolean fiery) {
        this(entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), power, explosionMode, fiery);
    }

    public ExplosionHelper(Entity entity, double x, double y, double z, float power, boolean damageBlocks, boolean fiery) {
        this(entity, x, y, z, power, damageBlocks ? ExplosionHelper.getMode(entity) : Explosion.BlockInteraction.KEEP, fiery);
    }

    public ExplosionHelper(Entity entity, double x, double y, double z, float power, Explosion.BlockInteraction explosionMode, boolean fiery) {
        this.source = entity;
        this.level = entity.m_9236_();
        this.radius = power;
        this.mode = explosionMode;
        this.damageCalculator = new ExplosionDamageCalculator();
        this.explosion = new Explosion(this.level, entity, null, this.damageCalculator, x, y, z, power, fiery, explosionMode);
    }

    public Vec3 getPos() {
        return this.explosion.getPosition();
    }

    public List<BlockPos> getHitBlocks() {
        return this.explosion.m_46081_();
    }

    public boolean tryExplodeBlock(BlockPos pos, BlockState block, float power) {
        return this.tryExplodeBlock(pos, block, this.level.m_6425_(pos), power);
    }

    public boolean tryExplodeBlock(BlockPos pos, BlockState block, FluidState fluid, float power) {
        float blockDamage = power * (0.7f + this.level.f_46441_.m_188501_() * 0.6f);
        Optional<Float> optional = this.getBlockExplosionResistance(pos, block, fluid);
        if (optional.isPresent()) {
            blockDamage -= (optional.get().floatValue() + 0.3f) * 0.3f;
        }
        return blockDamage > 0.0f && this.shouldBlockExplode(pos, block, blockDamage);
    }

    public Optional<Float> getBlockExplosionResistance(BlockPos pos, BlockState block) {
        return this.damageCalculator.m_6617_(this.explosion, (BlockGetter)this.level, pos, block, this.level.m_6425_(pos));
    }

    public Optional<Float> getBlockExplosionResistance(BlockPos pos, BlockState block, FluidState fluid) {
        return this.damageCalculator.m_6617_(this.explosion, (BlockGetter)this.level, pos, block, fluid);
    }

    public boolean shouldBlockExplode(BlockPos pos, BlockState block, float blockDamage) {
        return this.damageCalculator.m_6714_(this.explosion, (BlockGetter)this.level, pos, block, blockDamage);
    }

    public boolean initializeExplosion() {
        if (ForgeEventFactory.onExplosionStart((Level)this.level, (Explosion)this.explosion)) {
            return false;
        }
        this.explosion.m_46061_();
        return true;
    }

    public void finalizeExplosion() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.explosion.m_46075_(false);
            if (this.mode == Explosion.BlockInteraction.KEEP) {
                this.explosion.m_46080_();
            }
            Vec3 pos = this.getPos();
            for (ServerPlayer player : serverLevel.m_6907_()) {
                if (!(player.m_20275_(pos.f_82479_, pos.f_82480_, pos.f_82481_) < 4096.0)) continue;
                player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, this.radius, this.explosion.m_46081_(), (Vec3)this.explosion.m_46078_().get(player)));
            }
        } else {
            this.explosion.m_46075_(true);
        }
    }
}

