/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.util;

import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class References {
    public static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836"), "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    public static final String ENTITY_PACKAGE = "fathertoast.specialmobs.common.entity.";
    public static final String VANILLA_REPLACEMENT_FORMAT = "%s._Special%sEntity";
    public static final String SPECIAL_VARIANT_FORMAT = "%s.%sEntity";
    private static final String TEXTURE_FORMAT = "textures/entity/%s/%s%s.png";
    public static final String TEXTURE_BASE_SUFFIX = "";
    public static final String TEXTURE_EYES_SUFFIX = "_eyes";
    public static final String TEXTURE_OVERLAY_SUFFIX = "_overlay";
    public static final String TEXTURE_ANIMATION_SUFFIX = "_anim";
    public static final String TEXTURE_ANIMATION_EYES_SUFFIX = "_anim_eyes";
    public static final int NBT_TYPE_NUMERICAL = 99;
    public static final int NBT_TYPE_STRING = StringTag.m_129297_((String)"").m_7060_();
    public static final int NBT_TYPE_LIST = new ListTag().m_7060_();
    public static final int NBT_TYPE_COMPOUND = new CompoundTag().m_7060_();
    public static final String TAG_KNOCKBACK = "Knockback";
    public static final String TAG_FORGE_DATA = "ForgeData";
    public static final String TAG_INIT = "SpecialMobsInit";
    public static final String TAG_SPECIAL_MOB_DATA = "SpecialMobsData";
    public static final String TAG_RENDER_SCALE = "RenderScale";
    public static final String TAG_EXPERIENCE = "Experience";
    public static final String TAG_REGENERATION = "Regeneration";
    public static final String TAG_FALL_MULTI = "FallMulti";
    public static final String TAG_FIRE_IMMUNE = "FireImmune";
    public static final String TAG_BURN_IMMUNE = "BurningImmune";
    public static final String TAG_LEASHABLE = "Leashable";
    public static final String TAG_TRAP_IMMUNE = "UnderPressure";
    public static final String TAG_DROWN_IMMUNE = "DrownImmune";
    public static final String TAG_WATER_PUSH_IMMUNE = "WaterPushImmune";
    public static final String TAG_WATER_DAMAGE = "WaterDamage";
    public static final String TAG_STICKY_IMMUNE = "StickyImmune";
    public static final String TAG_POTION_IMMUNE = "PotionImmune";
    public static final String TAG_RANGED_DAMAGE = "RangedDamage";
    public static final String TAG_RANGED_SPREAD = "RangedSpread";
    public static final String TAG_RANGED_WALK_SPEED = "RangedWalkSpeed";
    public static final String TAG_RANGED_COOLDOWN_MIN = "RangedCDMin";
    public static final String TAG_RANGED_COOLDOWN_MAX = "RangedCDMax";
    public static final String TAG_MAX_RANGE = "MaxRange";
    public static final String TAG_SUPERCHARGED = "Supercharged";
    public static final String TAG_DRY_EXPLODE = "CannotExplodeWhileWet";
    public static final String TAG_WHILE_BURNING_EXPLODE = "ExplodesWhileBurning";
    public static final String TAG_WHEN_SHOT_EXPLODE = "ExplodesWhenShot";
    public static final String TAG_SHEATHED_ITEM = "SheathedItem";
    public static final String TAG_POTION_USE_TIME = "PotionUseTimer";
    public static final String TAG_BURST_COUNT = "FireballBurstCount";
    public static final String TAG_BURST_DELAY = "FireballBurstDelay";
    public static final String TAG_IS_BABY = "IsBaby";
    public static final String TAG_IS_SHIFTED = "IsShifted";
    public static final String TAG_SHIFT_TIME = "ShiftTime";
    public static final String TAG_BABIES = "Babies";
    public static final String TAG_EXTRA_BABIES = "ExtraBabies";
    public static final String TAG_SUMMONS = "Summons";
    public static final String TAG_GROWTH_LEVEL = "GrowthLevel";
    public static final String TAG_HEALTH_STACKS = "HealthStacks";
    public static final String TAG_FUSE_TIME = "FuseTime";
    public static final String TAG_AMMO = "Ammo";
    public static final String TAG_IS_FAKE = "IsFake";
    public static final String TAG_EXPLOSION_POWER = "ExplosionPower";

    public static int getRedBits(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreenBits(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlueBits(int color) {
        return color & 0xFF;
    }

    public static int getAlphaBits(int color) {
        return color >> 24 & 0xFF;
    }

    public static float getRed(int color) {
        return (float)References.getRedBits(color) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)References.getGreenBits(color) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)References.getBlueBits(color) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)References.getAlphaBits(color) / 255.0f;
    }

    public static ResourceLocation getEntityTexture(String path, String fileName) {
        return References.getEntityTexture(path, fileName, TEXTURE_BASE_SUFFIX);
    }

    public static ResourceLocation getEntityBaseTexture(String path, String fileName) {
        return References.getEntityTexture(path, fileName, TEXTURE_BASE_SUFFIX);
    }

    public static ResourceLocation getEntityEyesTexture(String path, String fileName) {
        return References.getEntityTexture(path, fileName, TEXTURE_EYES_SUFFIX);
    }

    public static ResourceLocation getEntityOverlayTexture(String path, String fileName) {
        return References.getEntityTexture(path, fileName, TEXTURE_OVERLAY_SUFFIX);
    }

    public static ResourceLocation getEntityShootingTexture(String path, String fileName) {
        return References.getEntityTexture(path, fileName, TEXTURE_ANIMATION_SUFFIX);
    }

    public static ResourceLocation getEntityShootingEyesTexture(String path, String fileName) {
        return References.getEntityTexture(path, fileName, TEXTURE_ANIMATION_EYES_SUFFIX);
    }

    public static ResourceLocation getEntityTexture(String path, String fileName, String suffix) {
        return SpecialMobs.resourceLoc(String.format(TEXTURE_FORMAT, path, fileName, suffix));
    }

    public static String[] translations(String key, String en, String es, String pt, String fr, String it, String de, String pir) {
        String[] translation = new String[]{key, en, es, pt, fr, it, de, pir};
        String[][] utf8ToUnicode = new String[][]{{"\u00e0", "\u00e0"}, {"\u00e1", "\u00e1"}, {"\u00e3", "\u00e3"}, {"\u00e4", "\u00e4"}, {"\u00e7", "\u00e7"}, {"\u00e8", "\u00e8"}, {"\u00e9", "\u00e9"}, {"\u00ea", "\u00ea"}, {"\u00ed", "\u00ed"}, {"\u00f3", "\u00f3"}, {"\u00f5", "\u00f5"}, {"\u00f6", "\u00f6"}, {"\u00f9", "\u00f9"}, {"\u00fb", "\u00fb"}, {"\u00fc", "\u00fc"}, {"\u0153", "\u0153"}};
        for (int i = 1; i < translation.length; ++i) {
            for (String[] fix : utf8ToUnicode) {
                translation[i] = translation[i].replace(fix[0], fix[1]);
            }
        }
        return translation;
    }

    public static enum LevelEvent {
        DISPENSER_DISPENSE(1000),
        DISPENSER_FAIL(1001),
        DISPENSER_LAUNCH(1002),
        ENDER_EYE_LAUNCH(1003),
        ENDER_EYE(2003),
        END_PORTAL_FRAME_FILL(1503),
        FIREWORK_ROCKET_SHOOT(1004),
        IRON_DOOR_OPEN(1005),
        WOODEN_DOOR_OPEN(1006),
        WOODEN_TRAPDOOR_OPEN(1007),
        FENCE_GATE_OPEN(1008),
        IRON_DOOR_CLOSE(1011),
        WOODEN_DOOR_CLOSE(1012),
        WOODEN_TRAPDOOR_CLOSE(1013),
        FENCE_GATE_CLOSE(1014),
        IRON_TRAPDOOR_CLOSE(1036),
        IRON_TRAPDOOR_OPEN(1037),
        FIRE_EXTINGUISH(1009),
        LAVA_EXTINGUISH(1501),
        REDSTONE_TORCH_BURNOUT(1502),
        GHAST_WARN(1015),
        GHAST_SHOOT(1016),
        ENDER_DRAGON_SHOOT(1017),
        ENDER_DRAGON_GROWL(3001),
        BLAZE_SHOOT(1018),
        ZOMBIE_ATTACK_WOODEN_DOOR(1019),
        ZOMBIE_ATTACK_IRON_DOOR(1020),
        ZOMBIE_BREAK_WOODEN_DOOR(1021),
        ZOMBIE_INFECT(1026),
        ZOMBIE_VILLAGER_CONVERTED(1027),
        ZOMBIE_CONVERTED_TO_DROWNED(1040),
        HUSK_CONVERTED_TO_ZOMBIE(1041),
        WITHER_BREAK_BLOCK(1022),
        WITHER_SHOOT(1024),
        BAT_TAKEOFF(1025),
        ANVIL_DESTROY(1029),
        ANVIL_USE(1030),
        ANVIL_LAND(1031),
        BREWING_STAND_BREW(1035),
        GRINDSTONE_USE(1042),
        BOOK_PAGE_TURN(1043),
        SMITHING_TABLE_USE(1044),
        PORTAL_TRAVEL(1032),
        CHORUS_FLOWER_GROW(1033),
        CHORUS_FLOWER_DEATH(1034),
        PHANTOM_BITE(1039),
        SMOKE_AND_FLAME(2004),
        EXPLOSION_PARTICLE(2008),
        CLOUD_PARTICLES(2009),
        EXPLOSION_EMITTER(3000);

        private final int ID;

        private LevelEvent(int id) {
            this.ID = id;
        }

        public void play(Entity entity) {
            if (!entity.m_20067_()) {
                this.play(entity.m_9236_(), entity.m_20183_());
            }
        }

        public void play(Level level, BlockPos pos) {
            this.play(level, null, pos);
        }

        public void play(Level level, @Nullable Player player, BlockPos pos) {
            level.m_5898_(player, this.ID, pos, 0);
        }
    }

    public static enum EntityEvent {
        HURT_SOUND(2),
        HURT_SOUND_THORNS(33),
        HURT_SOUND_DROWN(36),
        HURT_SOUND_BURNING(37),
        HURT_SOUND_SWEET_BERRY_BUSH(44),
        DEATH_SOUND(3),
        SHIELD_BLOCK_SOUND(29),
        SHIELD_BREAK_SOUND(30),
        TELEPORT_TRAIL_PARTICLES(46),
        ITEM_BREAK_FX_MAIN_HAND(47),
        ITEM_BREAK_FX_OFF_HAND(48),
        ITEM_BREAK_FX_HEAD(49),
        ITEM_BREAK_FX_CHEST(50),
        ITEM_BREAK_FX_LEGS(51),
        ITEM_BREAK_FX_FEET(52),
        HONEY_SLIDE_PARTICLES(53),
        HONEY_JUMP_PARTICLES(54),
        SWAP_HAND_ITEMS(55);

        private final byte ID;

        private EntityEvent(int id) {
            this.ID = (byte)id;
        }

        public void broadcast(LivingEntity entity) {
            entity.m_9236_().m_7605_((Entity)entity, this.ID);
        }
    }

    public static final class SetBlockFlags {
        public static final int BLOCK_UPDATE = 1;
        public static final int UPDATE_CLIENT = 2;
        public static final int SKIP_RENDER_UPDATE = 4;
        public static final int PRIORITY_RENDER_UPDATE = 8;
        public static final int SKIP_NEIGHBOR_UPDATE = 16;
        public static final int SKIP_NEIGHBOR_DROPS = 32;
        public static final int IS_MOVED = 64;
        public static final int SKIP_LIGHT_UPDATE = 128;
        public static final int DEFAULTS = 3;
    }
}

