/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.datagen;

import fathertoast.specialmobs.common.core.register.SMDamageTypes;
import fathertoast.specialmobs.datagen.SMBlockStateAndModelProvider;
import fathertoast.specialmobs.datagen.SMBlockTagProvider;
import fathertoast.specialmobs.datagen.SMDamageTagProvider;
import fathertoast.specialmobs.datagen.SMEntityTagProvider;
import fathertoast.specialmobs.datagen.SMItemModelProvider;
import fathertoast.specialmobs.datagen.SMItemTagProvider;
import fathertoast.specialmobs.datagen.SMLanguageProvider;
import fathertoast.specialmobs.datagen.SMLootTableProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="specialmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGatherListener {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(DataGatherListener::getProvider);
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new SMBlockStateAndModelProvider(packOutput, fileHelper));
            generator.addProvider(true, (DataProvider)new SMItemModelProvider(packOutput, fileHelper));
            for (Map.Entry<String, SMLanguageProvider.TranslationKey> entry : SMLanguageProvider.LANG_CODE_MAP.entrySet()) {
                generator.addProvider(true, (DataProvider)new SMLanguageProvider(packOutput, entry.getKey(), entry.getValue()));
            }
        }
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new SMLootTableProvider(packOutput));
            SMBlockTagProvider blockTagProvider = new SMBlockTagProvider(packOutput, lookupProvider, fileHelper);
            generator.addProvider(true, (DataProvider)blockTagProvider);
            generator.addProvider(true, (DataProvider)new SMItemTagProvider(packOutput, lookupProvider, blockTagProvider.m_274426_(), fileHelper));
            generator.addProvider(true, (DataProvider)new SMEntityTagProvider(packOutput, lookupProvider, fileHelper));
            generator.addProvider(true, (DataProvider)new SMDamageTagProvider(packOutput, lookupProvider, fileHelper));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, Set.of("specialmobs")));
        }
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_268580_, SMDamageTypes::bootstrap);
        registryBuilder.m_254916_(Registries.f_256952_, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }
}

