/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.datagen;

import fathertoast.specialmobs.common.block.MeltingIceBlock;
import fathertoast.specialmobs.common.block.UnderwaterSilverfishBlock;
import fathertoast.specialmobs.common.core.register.SMBlocks;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class SMBlockStateAndModelProvider
extends BlockStateProvider {
    private static final ResourceLocation R_TRANSLUCENT = new ResourceLocation("translucent");

    public SMBlockStateAndModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "specialmobs", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)SMBlocks.MELTING_ICE.get());
        String name = this.blockName(Blocks.f_50449_);
        for (int age = 0; age <= 3; ++age) {
            builder.partialState().with((Property)MeltingIceBlock.AGE, (Comparable)Integer.valueOf(age)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/" + name + "_" + age))).addModel();
        }
        ((ItemModelBuilder)this.itemModels().withExistingParent(SMBlocks.MELTING_ICE.getId().m_135815_(), this.mcLoc("block/" + name + "_0"))).renderType(R_TRANSLUCENT);
        for (UnderwaterSilverfishBlock.Type type : UnderwaterSilverfishBlock.Type.values()) {
            name = this.blockName(type.hostBlock());
            this.getVariantBuilder(type.block()).partialState().modelForState().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/" + name))).addModel();
            this.itemModels().withExistingParent(type.blockId(), this.mcLoc("block/" + name));
        }
    }

    private String blockName(Supplier<Block> block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block.get())).m_135815_();
    }

    private String blockName(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
    }
}

