/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.datagen.loot;

import fathertoast.specialmobs.datagen.loot.LootHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootPoolBuilder {
    private final String name;
    private UniformGenerator rolls = LootHelper.ONE_ROLL;
    private UniformGenerator bonusRolls = LootHelper.NO_ROLL;
    private final List<LootPoolSingletonContainer.Builder<?>> lootEntries = new ArrayList();
    private final List<LootItemCondition.Builder> poolConditions = new ArrayList<LootItemCondition.Builder>();
    private final List<LootItemFunction.Builder> poolFunctions = new ArrayList<LootItemFunction.Builder>();

    public LootPoolBuilder(String id) {
        this.name = id;
    }

    public LootPool.Builder toLootPool() {
        return LootHelper.build(LootPool.m_79043_(), this.lootEntries, this.poolConditions, this.poolFunctions).m_165133_((NumberProvider)this.rolls).m_165135_((NumberProvider)this.bonusRolls).name(this.name);
    }

    public LootPoolBuilder setRolls(float value) {
        this.rolls = UniformGenerator.m_165780_((float)0.0f, (float)value);
        return this;
    }

    public LootPoolBuilder setRolls(float min, float max) {
        this.rolls = UniformGenerator.m_165780_((float)min, (float)max);
        return this;
    }

    public LootPoolBuilder setBonusRolls(float value) {
        this.bonusRolls = UniformGenerator.m_165780_((float)0.0f, (float)value);
        return this;
    }

    public LootPoolBuilder setBonusRolls(float min, float max) {
        this.bonusRolls = UniformGenerator.m_165780_((float)min, (float)max);
        return this;
    }

    public LootPoolBuilder addEntry(LootPoolSingletonContainer.Builder<?> entry) {
        this.lootEntries.add(entry);
        return this;
    }

    public LootPoolBuilder addConditions(LootItemCondition.Builder ... conditions) {
        this.poolConditions.addAll(Arrays.asList(conditions));
        return this;
    }

    public LootPoolBuilder addFunctions(LootItemFunction.Builder ... functions) {
        this.poolFunctions.addAll(Arrays.asList(functions));
        return this;
    }

    public LootPoolBuilder addEntryTable(ResourceLocation lootTable) {
        return this.addEntryTable(lootTable, 1, 0, new LootItemCondition.Builder[0]);
    }

    public LootPoolBuilder addEntryTable(ResourceLocation lootTable, int weight, int quality, LootItemCondition.Builder ... conditions) {
        LootPoolSingletonContainer.Builder builder = LootTableReference.m_79776_((ResourceLocation)lootTable);
        for (LootItemCondition.Builder condition : conditions) {
            builder.m_79080_(condition);
        }
        return this.addEntry(builder.m_79707_(weight).m_79711_(quality));
    }

    public LootPoolBuilder addEntryEmpty(int weight, int quality, LootItemCondition.Builder ... conditions) {
        LootPoolSingletonContainer.Builder builder = EmptyLootItem.m_79533_();
        for (LootItemCondition.Builder condition : conditions) {
            builder.m_79080_(condition);
        }
        return this.addEntry(builder.m_79707_(weight).m_79711_(quality));
    }
}

