/*
 * Decompiled with CFR 0.152.
 */
package tomson124.simplyjetpacks.datagen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CustomShapelessRecipeBuilder
extends ShapelessRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private String group;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    public CustomShapelessRecipeBuilder(ItemLike result, int count) {
        super(RecipeCategory.MISC, result, count);
        this.result = result.m_5456_();
        this.count = count;
    }

    public CustomShapelessRecipeBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    private boolean hasCriteria() {
        return !this.advancement.m_138405_().isEmpty();
    }

    public static CustomShapelessRecipeBuilder shapeless(ItemLike item) {
        return new CustomShapelessRecipeBuilder(item, 1);
    }

    public static CustomShapelessRecipeBuilder shapeless(ItemLike item, int count) {
        return new CustomShapelessRecipeBuilder(item, count);
    }

    public CustomShapelessRecipeBuilder requires(TagKey<Item> item) {
        return this.requires(Ingredient.m_204132_(item));
    }

    public CustomShapelessRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public CustomShapelessRecipeBuilder requires(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public CustomShapelessRecipeBuilder requires(Ingredient item) {
        return this.requires(item, 1);
    }

    public CustomShapelessRecipeBuilder requires(Ingredient item, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(item);
        }
        return this;
    }

    public CustomShapelessRecipeBuilder unlockedBy(String name, Criterion criteria) {
        this.advancement.m_138383_(name, criteria);
        return this;
    }

    public CustomShapelessRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public void m_176498_(Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, BuiltInRegistries.f_257033_.m_7981_((Object)this.result));
    }

    public void m_176500_(Consumer<FinishedRecipe> consumer, String id) {
        ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_((Object)this.result);
        if (new ResourceLocation(id).equals((Object)resourceLocation)) {
            throw new IllegalStateException("Shapeless Recipe " + id + " should remove its 'save' argument");
        }
        this.m_126140_(consumer, new ResourceLocation(id));
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        if (this.hasCriteria()) {
            this.advancement.m_138396_(new ResourceLocation("simplyjetpacks", "root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        }
        consumer.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement));
    }

    private void ensureValid(ResourceLocation id) {
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;

        public Result(ResourceLocation id, Item result, @Nullable int count, String group, List<Ingredient> ingredients, Advancement.Builder advancement) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.ingredients = ingredients;
            this.advancement = advancement;
        }

        public void m_7917_(JsonObject jsonObject) {
            JsonArray ingredientsArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientsArray.add(ingredient.m_43942_());
            }
            jsonObject.add("ingredients", (JsonElement)ingredientsArray);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                resultObject.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)resultObject);
        }

        public JsonObject m_125966_() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", BuiltInRegistries.f_256769_.m_7981_(this.m_6637_()).toString());
            JsonArray conditionsArray = new JsonArray();
            if (!CustomShapelessRecipeBuilder.this.conditions.isEmpty()) {
                for (ICondition condition : CustomShapelessRecipeBuilder.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonObject.add("conditions", (JsonElement)conditionsArray);
            }
            this.m_7917_(jsonObject);
            return jsonObject;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return CustomShapelessRecipeBuilder.this.hasCriteria() ? this.advancement.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return new ResourceLocation("simplyjetpacks", (this.group != null ? this.group : "") + this.id.m_135815_());
        }
    }
}

