/*
 * Decompiled with CFR 0.152.
 */
package tomson124.simplyjetpacks.item;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;

public enum JetpackArmorMaterial implements ArmorMaterial
{
    PILOT_GOGGLES("pilot_goggles", 0, new int[]{0, 0, 0, 0}, 0, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_}), "item.armor.equip_leather", 0.0f, 0.0f),
    POTATO("potato", 0, new int[]{0, 0, 0, 0}, 0, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42620_}), "item.armor.equip_leather", 0.0f, 0.0f),
    JETPACK("jetpack", 0, new int[]{0, 2, 0, 0}, 10, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), "item.armor.equip_iron", 0.0f, 0.0f),
    JETPACK_ARMORED("jetpack_armored", 0, new int[]{0, 4, 0, 0}, 10, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), "item.armor.equip_iron", 0.0f, 0.0f),
    JETPLATE("jetplate", 0, new int[]{0, 12, 0, 0}, 10, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), "item.armor.equip_iron", 3.0f, 3.0f);

    private final String name;
    private final int durability;
    private final int[] damageReductionAmounts;
    private int enchantability;
    private final Lazy<Ingredient> repairIngredient;
    private final String equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private static final int[] max_damage_array;

    private JetpackArmorMaterial(String name, int durability, int[] defense, int enchantability, Supplier<Ingredient> repairIngredient, String equipSound, float toughness, float knockbackResistance) {
        this.name = name;
        this.durability = durability;
        this.damageReductionAmounts = defense;
        this.enchantability = enchantability;
        this.repairIngredient = Lazy.of(repairIngredient);
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public static void setStats(JetpackArmorMaterial armor, boolean isArmored, int enchant, int defense) {
        defense = isArmored ? defense : (defense - 1) / 2;
        armor.enchantability = enchant;
        armor.damageReductionAmounts[EquipmentSlot.CHEST.m_20749_()] = defense;
    }

    public int m_266425_(ArmorItem.Type slotIn) {
        return max_damage_array[slotIn.ordinal()] * this.durability;
    }

    public int m_7366_(ArmorItem.Type slotIn) {
        return this.damageReductionAmounts[slotIn.ordinal()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(this.equipSound));
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return "simplyjetpacks:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        max_damage_array = new int[]{13, 15, 16, 11};
    }
}

