/*
 * Decompiled with CFR 0.152.
 */
package tomson124.simplyjetpacks.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import tomson124.simplyjetpacks.handlers.KeybindForgeBusHandler;
import tomson124.simplyjetpacks.item.JetpackItem;
import tomson124.simplyjetpacks.network.NetworkHandler;
import tomson124.simplyjetpacks.network.packets.PacketToggleCharger;
import tomson124.simplyjetpacks.network.packets.PacketToggleEHover;
import tomson124.simplyjetpacks.network.packets.PacketToggleEngine;
import tomson124.simplyjetpacks.network.packets.PacketToggleHover;
import tomson124.simplyjetpacks.network.packets.PacketUpdateThrottle;
import tomson124.simplyjetpacks.util.JetpackUtil;
import tomson124.simplyjetpacks.util.SJTextUtil;

@OnlyIn(value=Dist.CLIENT)
public class JetpackScreen
extends Screen {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final float LEAN_FACTOR = 2.0f;
    private final ResourceLocation JETPACK_TEXTURE = new ResourceLocation("simplyjetpacks", "textures/gui/jetpack_screen.png");
    private static final int WIDTH = 176;
    private static final int HEIGHT = 120;
    private final JetpackItem jetpackItem;
    private final ItemStack jetpackStack;
    private ImageButton engine;
    private ImageButton hover;
    private ImageButton ehover;
    private ImageButton charger;
    private ForgeSlider slider;

    public JetpackScreen() {
        super((Component)Component.m_237115_((String)"screen.simplyjetpacks.jetpack_screen.title"));
        this.f_96543_ = 176;
        this.f_96544_ = 120;
        this.jetpackItem = (JetpackItem)JetpackUtil.getFromBothSlots((Player)JetpackScreen.minecraft.f_91074_).m_41720_();
        this.jetpackStack = JetpackUtil.getFromBothSlots((Player)JetpackScreen.minecraft.f_91074_);
    }

    protected void m_7856_() {
        int relX = (this.f_96543_ - 176) / 2;
        int relY = (this.f_96544_ - 120) / 2;
        this.engine = new ImageButton(relX + 120, relY + 16, 20, 20, 176, 0, 20, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleEngine()));
        this.m_142416_((GuiEventListener)this.engine);
        Item item = this.jetpackStack.m_41720_();
        if (item instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (jetpack.getJetpackType().getHoverMode()) {
                this.hover = new ImageButton(relX + 120, relY + 38, 20, 20, 216, 0, 20, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleHover()));
                this.m_142416_((GuiEventListener)this.hover);
                this.hover.f_93623_ = true;
            } else {
                this.hover = new ImageButton(relX + 120, relY + 38, 20, 20, 196, 40, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleHover()));
                this.m_142416_((GuiEventListener)this.hover);
                this.hover.f_93623_ = false;
            }
            if (jetpack.getJetpackType().getChargerMode()) {
                this.charger = new ImageButton(relX + 142, relY + 16, 20, 20, 196, 0, 20, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleCharger()));
                this.m_142416_((GuiEventListener)this.charger);
                this.charger.f_93623_ = true;
            } else {
                this.charger = new ImageButton(relX + 142, relY + 16, 20, 20, 196, 40, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleCharger()));
                this.m_142416_((GuiEventListener)this.charger);
                this.charger.f_93623_ = false;
            }
            if (jetpack.getJetpackType().getEmergencyHoverMode()) {
                this.ehover = new ImageButton(relX + 142, relY + 38, 20, 20, 236, 0, 20, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleEHover()));
                this.m_142416_((GuiEventListener)this.ehover);
                this.ehover.f_93623_ = true;
            } else {
                this.ehover = new ImageButton(relX + 142, relY + 38, 20, 20, 236, 40, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleEHover()));
                this.m_142416_((GuiEventListener)this.ehover);
                this.ehover.f_93623_ = false;
            }
        }
        this.slider = new ForgeSlider(relX + 10, relY + 98, 152, 16, (Component)Component.m_237115_((String)"screen.simplyjetpacks.throttle"), (Component)Component.m_237113_((String)"%"), 0.0, 100.0, (double)this.jetpackItem.getThrottle(this.jetpackStack), true);
        this.m_142416_((GuiEventListener)this.slider);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Object text;
        int relX = (this.f_96543_ - 176) / 2;
        int relY = (this.f_96544_ - 120) / 2;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.JETPACK_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(this.JETPACK_TEXTURE, relX, relY, 0, 0, 176, 120);
        assert (JetpackScreen.minecraft.f_91080_ != null);
        float halfScreenHeight = (float)JetpackScreen.minecraft.f_91080_.f_96544_ / 2.0f;
        float halfScreenWidth = (float)JetpackScreen.minecraft.f_91080_.f_96543_ / 2.0f;
        float angleX = -(((float)mouseX - halfScreenWidth) / halfScreenWidth * 2.0f);
        float angleY = -(((float)(mouseY + 25) - halfScreenHeight) / halfScreenHeight * 2.0f);
        InventoryScreen.renderEntityInInventoryFollowsAngle((GuiGraphics)graphics, (int)(relX + 80), (int)(relY + 90), (int)40, (float)angleX, (float)angleY, (LivingEntity)JetpackScreen.minecraft.f_91074_);
        graphics.m_280653_(JetpackScreen.minecraft.f_91062_, (Component)Component.m_237115_((String)this.jetpackStack.m_41778_()), relX + 88, relY + 5, 0xFFFFFF);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.JETPACK_TEXTURE);
        NetworkHandler.sendToServer(new PacketUpdateThrottle(this.slider.getValueInt()));
        int amount = this.getEnergyBarAmount();
        int barOffset = 78 - amount;
        int barX = 0;
        boolean useGradient = false;
        switch (this.jetpackItem.getModId()) {
            case "mek": {
                barX = 28;
                break;
            }
            case "ie": {
                barX = 56;
                useGradient = true;
                break;
            }
        }
        if (this.jetpackItem.isCreative()) {
            graphics.m_280218_(this.JETPACK_TEXTURE, relX + 10, relY + 16, 70, 178, 14, 78);
        } else {
            graphics.m_280218_(this.JETPACK_TEXTURE, relX + 10, relY + 16, barX, 178, 14, 78);
            if (useGradient) {
                graphics.m_280024_(relX + 12, relY + 18 + barOffset, relX + 22, relY + 14 + 78, -4909824, -10482944);
            } else {
                graphics.m_280218_(this.JETPACK_TEXTURE, relX + 10, relY + 16 + 1 + barOffset, barX + 14, 179, 14, amount - 2);
            }
        }
        if (mouseX >= relX + 10 && mouseY >= relY + 16 && mouseX < relX + 10 + 14 && mouseY < relY + 16 + 78 && (text = this.jetpackItem.isCreative() ? SJTextUtil.translate("tooltip", "infiniteEnergy", ChatFormatting.LIGHT_PURPLE, new Object[0]) : (this.jetpackItem.getEnergy(this.jetpackStack) == 0 ? SJTextUtil.translate("hud", "energyDepleted", ChatFormatting.RED, new Object[0]) : null)) != null) {
            graphics.m_280557_(this.f_96547_, text, mouseX, mouseY);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private int getEnergyBarAmount() {
        Item item = this.jetpackStack.m_41720_();
        if (item instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (jetpack.isCreative()) {
                return 78;
            }
            int i = jetpack.getEnergy(this.jetpackStack);
            int j = jetpack.getCapacity(this.jetpackStack);
            return (int)(j != 0 && i != 0 ? (long)i * 78L / (long)j : 0L);
        }
        return 0;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (KeybindForgeBusHandler.JETPACK_GUI_KEY.m_90832_(keyCode, scanCode) || JetpackScreen.minecraft.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            minecraft.m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

