/*
 * Decompiled with CFR 0.152.
 */
package tomson124.simplyjetpacks.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tomson124.simplyjetpacks.config.SimplyJetpacksConfig;
import tomson124.simplyjetpacks.item.JetpackItem;

public class SJTextUtil {
    private static final Component on = SJTextUtil.translate("misc", "enabled", ChatFormatting.GREEN, new Object[0]);
    private static final Component off = SJTextUtil.translate("misc", "disabled", ChatFormatting.RED, new Object[0]);
    private static final Component notAvailable = SJTextUtil.translate("misc", "notAvailable", ChatFormatting.DARK_GRAY, new Object[0]);
    private static final String ENERGY_FORMAT = "%,d";

    public static Component translate(String prefix, String suffix, ChatFormatting style, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "simplyjetpacks", suffix);
        return Component.m_237110_((String)key, (Object[])params).m_130940_(style);
    }

    public static Component translate(String prefix, String suffix, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "simplyjetpacks", suffix);
        return Component.m_237110_((String)key, (Object[])params);
    }

    public static Component energy(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return SJTextUtil.translate("misc", "energy", s1);
    }

    public static Component energyPerTick(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return SJTextUtil.translate("misc", "energyPerTick", ChatFormatting.WHITE, new Object[]{s1});
    }

    public static Component energyWithMax(int amount, int max) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        String s2 = String.format(ENERGY_FORMAT, max);
        return SJTextUtil.translate("misc", "energyWithMax", s1, s2);
    }

    public static Component fluidWithMax(IFluidHandler fluidHandler, int tank) {
        FluidStack stack = fluidHandler.getFluidInTank(tank);
        return SJTextUtil.fluidWithMax(stack, fluidHandler.getTankCapacity(tank));
    }

    public static Component fluidWithMax(FluidStack stack, int tankCapacity) {
        Component fluidName = stack.getDisplayName();
        String s1 = String.format(ENERGY_FORMAT, stack.getAmount());
        String s2 = String.format(ENERGY_FORMAT, tankCapacity);
        return SJTextUtil.translate("misc", "fluidWithMax", fluidName, s1, s2);
    }

    public static Component getShiftText() {
        return SJTextUtil.translate("tooltip", "showDetails", Component.m_237113_((String)"Shift").m_130940_(ChatFormatting.GOLD));
    }

    public static void addBaseInfo(ItemStack stack, List<Component> list) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        list.add(SJTextUtil.translate("tooltip", "tier", jetpack.tier));
        if (jetpack.isCreative()) {
            list.add(SJTextUtil.translate("tooltip", "infiniteEnergy", ChatFormatting.LIGHT_PURPLE, new Object[0]));
        } else {
            list.add(SJTextUtil.energyWithMax(jetpack.getEnergy(stack), jetpack.getCapacity(stack)));
        }
    }

    public static void addShiftInfo(ItemStack stack, List<Component> list) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.engine", ChatFormatting.GOLD, new Object[]{jetpack.isEngineOn(stack) ? on : off}));
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.hover", ChatFormatting.GOLD, new Object[]{jetpack.isHoverOn(stack) ? on : off}));
        if (jetpack.getJetpackType().getChargerMode()) {
            list.add(SJTextUtil.translate("tooltip", "itemJetpack.charger", ChatFormatting.GOLD, new Object[]{jetpack.isChargerOn(stack) ? on : off}));
        }
        if (!jetpack.isCreative()) {
            list.add(SJTextUtil.translate("tooltip", "itemJetpack.energyUsage", ChatFormatting.GOLD, new Object[]{SJTextUtil.energyPerTick(jetpack.getEnergyUsage(stack))}));
        }
        Component particle = SJTextUtil.translate("tooltip", "particle." + JetpackItem.getParticleId(stack), ChatFormatting.WHITE, new Object[0]);
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.particleType", ChatFormatting.GOLD, new Object[]{particle}));
        MutableComponent throttle = Component.m_237113_((String)(jetpack.getThrottle(stack) + "%")).m_130940_(ChatFormatting.WHITE);
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.throttle", ChatFormatting.GOLD, new Object[]{throttle}));
    }

    public static void addHUDInfoText(ItemStack stack, List<Component> list) {
        if (((Boolean)SimplyJetpacksConfig.showThrottle.get()).booleanValue()) {
            JetpackItem jetpack = (JetpackItem)stack.m_41720_();
            list.add(SJTextUtil.translate("hud", "throttle", jetpack.getThrottle(stack)));
        }
        list.add(SJTextUtil.getEnergyText(stack));
        list.add(SJTextUtil.getHUDStates(stack));
    }

    public static Component getEnergyText(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        if (jetpack.isCreative()) {
            return SJTextUtil.translate("hud", "energyDisplay", SJTextUtil.translate("hud", "infiniteEnergy", ChatFormatting.LIGHT_PURPLE, new Object[0]));
        }
        int percent = (int)Math.ceil((double)jetpack.getEnergy(stack) / (double)jetpack.getCapacity(stack) * 100.0);
        Component percentageText = SJTextUtil.getColoredPercent(percent);
        Component exactText = SJTextUtil.energy(jetpack.getEnergy(stack));
        if (((Boolean)SimplyJetpacksConfig.showExactEnergy.get()).booleanValue()) {
            return SJTextUtil.translate("hud", "energyDisplayExtra", percentageText, exactText);
        }
        return SJTextUtil.translate("hud", "energyDisplay", percentageText);
    }

    public static Component getColoredPercent(int percent) {
        if (percent > 70) {
            return Component.m_237113_((String)String.format("%s%%", percent)).m_130940_(ChatFormatting.GREEN);
        }
        if (percent > 40) {
            return Component.m_237113_((String)String.format("%s%%", percent)).m_130940_(ChatFormatting.YELLOW);
        }
        if (percent > 10) {
            return Component.m_237113_((String)String.format("%s%%", percent)).m_130940_(ChatFormatting.GOLD);
        }
        if (percent > 0) {
            return Component.m_237113_((String)String.format("%s%%", percent)).m_130940_(ChatFormatting.RED);
        }
        return SJTextUtil.translate("hud", "energyDepleted", ChatFormatting.RED, new Object[0]);
    }

    public static Component getHUDStates(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        ArrayList<Component> statesTexts = new ArrayList<Component>();
        int stateCount = 1;
        ChatFormatting on = ChatFormatting.GREEN;
        ChatFormatting off = ChatFormatting.RED;
        ChatFormatting notAvailable = ChatFormatting.DARK_GRAY;
        Component engineState = SJTextUtil.translate("hud", "engine", jetpack.isEngineOn(stack) ? on : off, new Object[0]);
        Component hoverState = SJTextUtil.translate("hud", "hover", jetpack.isHoverOn(stack) ? on : off, new Object[0]);
        Component eHoverState = SJTextUtil.translate("hud", "eHover", jetpack.getJetpackType().getEmergencyHoverMode() ? (jetpack.isEHoverOn(stack) ? on : off) : notAvailable, new Object[0]);
        Component chargerState = SJTextUtil.translate("hud", "charger", jetpack.getJetpackType().getChargerMode() ? (jetpack.isChargerOn(stack) ? on : off) : notAvailable, new Object[0]);
        statesTexts.add(engineState);
        if (((Boolean)SimplyJetpacksConfig.showHoverState.get()).booleanValue() && jetpack.getJetpackType().getHoverMode()) {
            statesTexts.add(hoverState);
            ++stateCount;
        }
        if (((Boolean)SimplyJetpacksConfig.showEHoverState.get()).booleanValue() && jetpack.getJetpackType().getEmergencyHoverMode()) {
            statesTexts.add(eHoverState);
            ++stateCount;
        }
        if (((Boolean)SimplyJetpacksConfig.showChargerState.get()).booleanValue() && jetpack.getJetpackType().getChargerMode()) {
            statesTexts.add(chargerState);
            ++stateCount;
        }
        return SJTextUtil.translate("hud", "jetpackStates." + stateCount, statesTexts.toArray());
    }

    public static Component getStateToggle(String state, boolean value) {
        return SJTextUtil.translate("chat", "itemJetpack." + state, value ? on : off);
    }

    public static Component getEmergencyText() {
        return SJTextUtil.translate("chat", "itemJetpack.emergencyHoverModeActivated", ChatFormatting.RED, new Object[0]);
    }
}

