/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.armory.common.item.darksteel;

import com.enderio.armory.common.capability.DarkSteelUpgradeable;
import com.enderio.armory.common.config.ArmoryConfig;
import com.enderio.armory.common.init.ArmoryItems;
import com.enderio.armory.common.item.darksteel.IDarkSteelItem;
import com.enderio.armory.common.lang.ArmoryLang;
import com.enderio.core.common.item.ITabVariants;
import com.enderio.core.common.util.BlockUtil;
import com.enderio.core.common.util.EnergyUtil;
import com.enderio.core.common.util.TooltipUtil;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class DarkSteelAxeItem
extends AxeItem
implements IDarkSteelItem,
ITabVariants {
    public DarkSteelAxeItem(Item.Properties pProperties) {
        super(ArmoryItems.DARK_STEEL_TIER, 5.0f, -3.0f, pProperties);
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int finalDamage = this.getEmpoweredUpgrade(stack).map(empoweredUpgrade -> empoweredUpgrade.adjustDamage(this.getDamage(stack), newDamage)).orElse(newDamage);
        super.setDamage(stack, finalDamage);
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        float baseSpeed = this.canHarvest(pStack, pState) ? this.f_40980_ : 1.0f;
        return this.getEmpoweredUpgrade(pStack).map(empoweredUpgrade -> Float.valueOf(empoweredUpgrade.adjustDestroySpeed(baseSpeed))).orElse(Float.valueOf(baseSpeed)).floatValue();
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            if (pEntityLiving.m_6047_() && pState.m_204336_(BlockTags.f_13106_) && EnergyUtil.getEnergyStored(pStack) > 0) {
                int maxSearchSize = 400;
                HashSet<BlockPos> chopCandidates = new HashSet<BlockPos>();
                this.collectTreeBlocks(pLevel, pPos, new HashSet<BlockPos>(), chopCandidates, maxSearchSize, pState.m_60734_());
                chopCandidates.remove(pPos);
                int energyPerBlock = (Integer)ArmoryConfig.COMMON.DARK_STEEL_AXE_ENERGY_PER_FELLED_LOG.get();
                int maxBlocks = EnergyUtil.getEnergyStored(pStack) / energyPerBlock;
                AbstractCollection toChop = chopCandidates;
                if (maxBlocks < chopCandidates.size()) {
                    ArrayList<BlockPos> orderedChopList = new ArrayList<BlockPos>(chopCandidates);
                    orderedChopList.sort((o1, o2) -> Integer.compare(o2.m_123342_(), o1.m_123342_()));
                    toChop = orderedChopList;
                }
                int chopCount = 0;
                int energyUse = 0;
                for (BlockPos chopPos : toChop) {
                    if (!BlockUtil.removeBlock(pLevel, player, pStack, chopPos)) continue;
                    energyUse += energyPerBlock;
                    if (++chopCount < maxBlocks) continue;
                    break;
                }
                if (energyUse > 0) {
                    EnergyUtil.extractEnergy(pStack, energyUse, false);
                }
            }
        }
        return super.m_6813_(pStack, pLevel, pState, pPos, pEntityLiving);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.canHarvest(stack, state) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.m_43314_(), (BlockState)state);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (this.hasFork(pContext.m_43722_())) {
            return Items.f_42392_.m_6225_(pContext);
        }
        return super.m_6225_(pContext);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return super.canPerformAction(stack, toolAction) || this.hasFork(stack) && ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction);
    }

    private boolean canHarvest(ItemStack stack, BlockState state) {
        return state.m_204336_(BlockTags.f_144280_) || state.m_204336_(BlockTags.f_144281_) && this.hasFork(stack);
    }

    private boolean hasFork(ItemStack stack) {
        return DarkSteelUpgradeable.hasUpgrade(stack, "enderio.darksteel.upgrade.fork");
    }

    private void collectTreeBlocks(Level level, BlockPos pos, Set<BlockPos> checkedPos, Set<BlockPos> toChop, int maxBlocks, Block targetBock) {
        if (toChop.size() >= maxBlocks || checkedPos.contains(pos)) {
            return;
        }
        checkedPos.add(pos);
        BlockState checkState = level.m_8055_(pos);
        if (checkState.m_60713_(targetBock)) {
            toChop.add(pos);
            HashSet<BlockPos> toCheck = new HashSet<BlockPos>();
            this.surrounding(toCheck, pos);
            this.surrounding(toCheck, pos.m_7494_());
            toCheck.add(pos.m_7494_());
            for (BlockPos newPos : toCheck) {
                this.collectTreeBlocks(level, newPos, checkedPos, toChop, maxBlocks, targetBock);
            }
        }
    }

    private void surrounding(Set<BlockPos> res, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                res.add(pos.m_7918_(x, 0, z));
            }
        }
        res.remove(pos);
    }

    @Override
    public void addCurrentUpgradeTooltips(ItemStack itemStack, List<Component> tooltips, boolean isDetailed) {
        if (isDetailed && this.getEmpoweredUpgrade(itemStack).isPresent()) {
            tooltips.add((Component)TooltipUtil.withArgs(ArmoryLang.DS_UPGRADE_EMPOWERED_EFFICIENCY, ArmoryConfig.COMMON.EMPOWERED_EFFICIENCY_BOOST.get()));
        }
        IDarkSteelItem.super.addCurrentUpgradeTooltips(itemStack, tooltips, isDetailed);
    }

    public boolean m_5812_(ItemStack pStack) {
        return DarkSteelUpgradeable.hasUpgrade(pStack, "enderio.darksteel.upgrade.empowered");
    }

    @Override
    public void addAllVariants(CreativeModeTabModifier modifier) {
        modifier.m_246326_((ItemLike)this);
        modifier.m_246342_(this.createFullyUpgradedStack((Item)this));
    }

    public boolean m_142522_(ItemStack pStack) {
        return this.isDurabilityBarVisible(pStack);
    }
}

