/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.loot;

import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.item.misc.BrokenSpawnerItem;
import com.enderio.base.common.tag.EIOTags;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class BrokenSpawnerLootModifier
extends LootModifier {
    public static final Supplier<Codec<BrokenSpawnerLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> BrokenSpawnerLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, BrokenSpawnerLootModifier::new)));

    public BrokenSpawnerLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockEntity entity = (BlockEntity)context.m_165124_(LootContextParams.f_81462_);
        if (entity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)entity;
            if (!((ItemStack)context.m_165124_(LootContextParams.f_81463_)).m_204117_(EIOTags.Items.BROKEN_SPAWNER_BLACKLIST) && (double)context.m_230907_().m_188501_() < (Double)BaseConfig.COMMON.BLOCKS.BROKEN_SPAWNER_DROP_CHANCE.get()) {
                BaseSpawner spawner = spawnerBlockEntity.m_59801_();
                CompoundTag entityTag = spawner.f_45444_.m_186567_();
                if (entityTag.m_128441_("id")) {
                    ResourceLocation type = new ResourceLocation(entityTag.m_128461_("id"));
                    ItemStack brokenSpawner = BrokenSpawnerItem.forType(type);
                    generatedLoot.add((Object)brokenSpawner);
                }
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

