/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.network;

import com.enderio.base.common.travel.TravelSavedData;
import com.enderio.core.common.network.Packet;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RemoveTravelTargetPacket
implements Packet {
    private final BlockPos pos;

    public RemoveTravelTargetPacket(BlockPos pos) {
        this.pos = pos;
    }

    public RemoveTravelTargetPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130064_(this.pos);
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ClientHandler.handle(this.pos);
    }

    public static class ClientHandler {
        static void handle(BlockPos pos) {
            TravelSavedData travelData = TravelSavedData.getTravelData((Level)Minecraft.m_91087_().f_91073_);
            travelData.removeTravelTargetAt((Level)Minecraft.m_91087_().f_91073_, pos);
        }
    }

    public static class Handler
    extends Packet.PacketHandler<RemoveTravelTargetPacket> {
        @Override
        public RemoveTravelTargetPacket fromNetwork(FriendlyByteBuf buf) {
            return new RemoveTravelTargetPacket(buf);
        }

        @Override
        public void toNetwork(RemoveTravelTargetPacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

