/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.integrations.mekanism;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ConduitData;
import java.util.Optional;
import mekanism.api.chemical.merged.BoxedChemical;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ChemicalConduitData
implements ConduitData<ChemicalConduitData> {
    public final boolean isMultiChemical;
    BoxedChemical lockedChemical = BoxedChemical.EMPTY;
    boolean shouldReset = false;
    private static final String KEY_SHOULD_RESET = "ShouldReset";
    private static final String KEY_LOCKED_FLUID = "LockedFluid";

    public ChemicalConduitData(boolean shouldReset, boolean isMultiChemical, Optional<BoxedChemical> lockedChemical) {
        this.shouldReset = shouldReset;
        this.isMultiChemical = isMultiChemical;
        this.lockedChemical = lockedChemical.orElse(BoxedChemical.EMPTY);
    }

    public ChemicalConduitData(boolean isMultiChemical) {
        this.isMultiChemical = isMultiChemical;
    }

    @Override
    public void onConnectTo(ChemicalConduitData otherData) {
        if (!this.lockedChemical.isEmpty()) {
            if (!otherData.lockedChemical.isEmpty() && !this.lockedChemical.equals((Object)otherData.lockedChemical)) {
                EnderIO.LOGGER.warn("incompatible chemical conduits merged");
            }
            otherData.setlockedChemical(this.lockedChemical);
        } else if (!otherData.lockedChemical.isEmpty()) {
            this.setlockedChemical(otherData.lockedChemical);
        }
    }

    @Override
    public boolean canConnectTo(ChemicalConduitData otherData) {
        return this.lockedChemical.isEmpty() || otherData.lockedChemical.isEmpty() || this.lockedChemical.equals((Object)otherData.lockedChemical);
    }

    private void setlockedChemical(BoxedChemical lockedChemical) {
        this.lockedChemical = lockedChemical;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(KEY_SHOULD_RESET, this.shouldReset);
        if (!this.lockedChemical.isEmpty()) {
            tag.m_128365_(KEY_LOCKED_FLUID, (Tag)this.lockedChemical.write(new CompoundTag()));
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        if (compoundTag.m_128441_(KEY_SHOULD_RESET)) {
            this.shouldReset = compoundTag.m_128471_(KEY_SHOULD_RESET);
        }
        if (compoundTag.m_128425_(KEY_LOCKED_FLUID, 10)) {
            this.lockedChemical = BoxedChemical.read((CompoundTag)compoundTag.m_128469_(KEY_LOCKED_FLUID));
        }
    }
}

