/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.items;

import com.enderio.api.conduit.ConduitType;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.conduits.common.conduit.ConduitBundle;
import com.enderio.conduits.common.conduit.block.ConduitBlockEntity;
import com.enderio.conduits.common.conduit.connection.ConnectionState;
import com.enderio.conduits.common.conduit.connection.DynamicConnectionState;
import com.enderio.conduits.common.network.C2SSyncProbeState;
import com.enderio.conduits.common.util.InteractionUtil;
import com.enderio.core.common.network.CoreNetwork;
import com.enderio.core.common.util.TooltipUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ConduitProbeItem
extends Item {
    public static final String STATE_FIELD = "STATE";
    public static final String CONDUIT_DATA = "CONDUIT_DATA";
    public static final String IS_INSERT = "IS_INSERT";
    public static final String IS_EXTRACT = "IS_EXTRACT";
    public static final String INSERT_CHANNEL = "INSERT_CHANNEL";
    public static final String EXTRACT_CHANNEL = "EXTRACT_CHANNEL";
    public static final String REDSTONE_CONTROL = "REDSTONE_CONTROL";
    public static final String REDSTONE_CHANNEL = "REDSTONE_CHANNEL";

    public ConduitProbeItem(Item.Properties properties) {
        super(properties);
    }

    public static State getState(ItemStack stack) {
        return State.values()[stack.m_41784_().m_128451_(STATE_FIELD)];
    }

    public static void setState(ItemStack stack, State state, boolean syncToServer) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(STATE_FIELD, state.ordinal());
        if (syncToServer) {
            CoreNetwork.sendToServer(new C2SSyncProbeState(state));
        }
    }

    public static void switchState(ItemStack stack, boolean syncToServer) {
        CompoundTag tag = stack.m_41784_();
        int newState = (tag.m_128451_(STATE_FIELD) + 1) % State.values().length;
        ConduitProbeItem.setState(stack, State.values()[newState], syncToServer);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockEntity block = context.m_43725_().m_7702_(context.m_8083_());
        if (block instanceof ConduitBlockEntity) {
            ConduitBlockEntity conduit = (ConduitBlockEntity)block;
            if (context.m_43725_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            switch (ConduitProbeItem.getState(stack)) {
                case COPY_PASTE: {
                    if (context.m_7078_()) {
                        this.handleCopy(conduit, InteractionUtil.fromClickLocation(context.m_43720_(), context.m_8083_().m_252807_()), stack);
                        break;
                    }
                    this.handlePaste(conduit, InteractionUtil.fromClickLocation(context.m_43720_(), context.m_8083_().m_252807_()), stack);
                    break;
                }
                case PROBE: {
                    context.m_43723_().m_213846_((Component)Component.m_237113_((String)"This feature isn't implemented yet.").m_130940_(ChatFormatting.RED));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    private void handleCopy(ConduitBlockEntity conduitBlock, Direction face, ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        CompoundTag conduitData = new CompoundTag();
        tag.m_128365_(CONDUIT_DATA, (Tag)conduitData);
        ConduitBundle bundle = conduitBlock.getBundle();
        if (bundle.getConnectedTypes(face).isEmpty()) {
            return;
        }
        bundle.getTypes().forEach(conduitType -> {
            ConnectionState connectionState = bundle.getConnectionState(face, (ConduitType<?>)conduitType);
            CompoundTag typeTag = new CompoundTag();
            if (connectionState.isConnection() && connectionState instanceof DynamicConnectionState) {
                DynamicConnectionState dynamic = (DynamicConnectionState)connectionState;
                typeTag.m_128379_(IS_INSERT, dynamic.isInsert());
                typeTag.m_128379_(IS_EXTRACT, dynamic.isExtract());
                typeTag.m_128405_(INSERT_CHANNEL, dynamic.insertChannel().ordinal());
                typeTag.m_128405_(EXTRACT_CHANNEL, dynamic.extractChannel().ordinal());
                typeTag.m_128405_(REDSTONE_CONTROL, dynamic.control().ordinal());
                typeTag.m_128405_(REDSTONE_CHANNEL, dynamic.redstoneChannel().ordinal());
            } else {
                typeTag.m_128379_(IS_INSERT, false);
                typeTag.m_128379_(IS_EXTRACT, false);
            }
            conduitData.m_128365_(Objects.requireNonNull(ConduitType.getKey(conduitType)).toString(), (Tag)typeTag);
        });
    }

    public void handlePaste(ConduitBlockEntity conduitBlock, Direction face, ItemStack itemStack) {
        Tag tag;
        CompoundTag tag2 = itemStack.m_41783_();
        if (tag2 == null || !((tag = tag2.m_128423_(CONDUIT_DATA)) instanceof CompoundTag)) {
            return;
        }
        CompoundTag conduitData = (CompoundTag)tag;
        ConduitBundle bundle = conduitBlock.getBundle();
        bundle.getTypes().forEach(conduitType -> {
            CompoundTag typeTag = conduitData.m_128469_(Objects.requireNonNull(ConduitType.getKey(conduitType)).toString());
            ConnectionState prevConnectionState = bundle.getConnectionState(face, (ConduitType<?>)conduitType);
            DynamicConnectionState connectionState = null;
            if (prevConnectionState instanceof DynamicConnectionState) {
                connectionState = (DynamicConnectionState)prevConnectionState;
            }
            boolean wasConnected = connectionState != null;
            boolean isInsert = typeTag.m_128471_(IS_INSERT);
            boolean isExtract = typeTag.m_128471_(IS_EXTRACT);
            DynamicConnectionState newState = new DynamicConnectionState(isInsert, ColorControl.values()[typeTag.m_128451_(INSERT_CHANNEL)], isExtract, ColorControl.values()[typeTag.m_128451_(EXTRACT_CHANNEL)], RedstoneControl.values()[typeTag.m_128451_(REDSTONE_CONTROL)], ColorControl.values()[typeTag.m_128451_(REDSTONE_CHANNEL)], wasConnected ? connectionState.filterInsert() : ItemStack.f_41583_, wasConnected ? connectionState.filterExtract() : ItemStack.f_41583_, wasConnected ? connectionState.upgradeExtract() : ItemStack.f_41583_);
            conduitBlock.handleConnectionStateUpdate(face, (ConduitType<?>)conduitType, newState);
        });
        conduitBlock.m_6596_();
        conduitBlock.updateClient();
        conduitBlock.updateEmptyDynConnection();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (!(stack.m_41720_() instanceof ConduitProbeItem)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (String s : ConduitProbeItem.getState(stack).toString().toLowerCase().split("_")) {
            builder.append(StringUtils.capitalize((String)s));
            builder.append(" ");
        }
        builder.deleteCharAt(builder.length() - 1);
        tooltipComponents.add(TooltipUtil.style(Component.m_237110_((String)"tooltip.enderio.conduit_probe.mode", (Object[])new Object[]{builder.toString()})));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static enum State {
        PROBE,
        COPY_PASTE;

    }
}

