/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.gui.widget;

import com.enderio.EnderIO;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.client.gui.widgets.EIOWidget;
import com.enderio.core.common.util.TooltipUtil;
import com.enderio.machines.common.io.energy.ILargeMachineEnergyStorage;
import com.enderio.machines.common.io.energy.IMachineEnergyStorage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EnergyWidget
extends EIOWidget {
    protected static final ResourceLocation WIDGETS = EnderIO.loc("textures/gui/widgets.png");
    protected final Screen displayOn;
    private final Supplier<IMachineEnergyStorage> storageSupplier;

    public EnergyWidget(Screen displayOn, Supplier<IMachineEnergyStorage> storageSupplier, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.displayOn = displayOn;
        this.storageSupplier = storageSupplier;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        IMachineEnergyStorage storage = this.storageSupplier.get();
        if (storage.getMaxEnergyStored() <= 0) {
            return;
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        float filledVolume = (float)((double)EnergyWidget.getEnergyStored(storage) / (double)EnergyWidget.getMaxEnergyStored(storage));
        int renderableHeight = (int)(filledVolume * (float)this.height);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, (float)(this.height - 16), 0.0f);
        int i = 0;
        while ((double)i < Math.ceil((float)renderableHeight / 16.0f)) {
            int drawingHeight = Math.min(16, renderableHeight - 16 * i);
            int notDrawingHeight = 16 - drawingHeight;
            guiGraphics.m_280398_(WIDGETS, this.x, this.y + notDrawingHeight, 0, 0.0f, (float)(128 + notDrawingHeight), this.width, drawingHeight, 256, 256);
            guiGraphics.m_280168_().m_252880_(0.0f, -16.0f, 0.0f);
            ++i;
        }
        RenderSystem.disableDepthTest();
        guiGraphics.m_280168_().m_85849_();
        this.renderToolTip(guiGraphics, mouseX, mouseY);
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    public void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isHovered(mouseX, mouseY)) {
            IMachineEnergyStorage storage = this.storageSupplier.get();
            NumberFormat fmt = NumberFormat.getInstance(Locale.ENGLISH);
            guiGraphics.m_280557_(this.displayOn.getMinecraft().f_91062_, (Component)TooltipUtil.withArgs(EIOLang.ENERGY_AMOUNT, fmt.format(EnergyWidget.getEnergyStored(storage)) + "/" + fmt.format(EnergyWidget.getMaxEnergyStored(storage))), mouseX, mouseY);
        }
    }

    private static long getEnergyStored(IMachineEnergyStorage storage) {
        if (storage instanceof ILargeMachineEnergyStorage) {
            ILargeMachineEnergyStorage largeStorage = (ILargeMachineEnergyStorage)((Object)storage);
            return largeStorage.getLargeEnergyStored();
        }
        return storage.getEnergyStored();
    }

    private static long getMaxEnergyStored(IMachineEnergyStorage storage) {
        if (storage instanceof ILargeMachineEnergyStorage) {
            ILargeMachineEnergyStorage largeStorage = (ILargeMachineEnergyStorage)((Object)storage);
            return largeStorage.getLargeMaxEnergyStored();
        }
        return storage.getMaxEnergyStored();
    }
}

