/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei.category;

import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.machines.client.gui.screen.AlloySmelterScreen;
import com.enderio.machines.client.gui.screen.StirlingGeneratorScreen;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.integrations.jei.util.MachineRecipeCategory;
import com.enderio.machines.common.integrations.jei.util.RecipeUtil;
import com.enderio.machines.common.lang.MachineLang;
import com.enderio.machines.common.recipe.AlloySmeltingRecipe;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AlloySmeltingCategory
extends MachineRecipeCategory<AlloySmeltingRecipe> {
    public static final RecipeType<AlloySmeltingRecipe> TYPE = RecipeType.create((String)"enderio", (String)"alloy_smelting", AlloySmeltingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic staticFlame;
    private final IDrawable animatedFlame;

    public AlloySmeltingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(AlloySmelterScreen.BG_TEXTURE_AUTO, 53, 6, 107, 73);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)MachineBlocks.ALLOY_SMELTER.get()));
        this.staticFlame = guiHelper.createDrawable(StirlingGeneratorScreen.BG_TEXTURE, 176, 0, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public RecipeType<AlloySmeltingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return MachineLang.CATEGORY_ALLOY_SMELTING;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloySmeltingRecipe recipe, IFocusGroup focuses) {
        List<CountedIngredient> inputs = recipe.getInputs();
        if (!inputs.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 11).addItemStacks(inputs.get(0).getItems());
        } else {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 11);
        }
        if (inputs.size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 26, 1).addItemStacks(inputs.get(1).getItems());
        } else {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 26, 11);
        }
        if (inputs.size() > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 50, 11).addItemStacks(inputs.get(2).getItems());
        } else {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 50, 11);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 26, 52).addItemStacks(List.of(RecipeUtil.getResultStacks(recipe).get(0).getItem()));
    }

    public void draw(AlloySmeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(guiGraphics, 3, 29);
        this.animatedFlame.draw(guiGraphics, 51, 29);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, AlloySmeltingCategory.getBasicEnergyString(recipe), 60, 50, -8355712, false);
    }

    public List<Component> getTooltipStrings(AlloySmeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (mouseX > 60.0 && mouseY > 50.0 && mouseX < (double)(60 + mc.f_91062_.m_92852_((FormattedText)AlloySmeltingCategory.getBasicEnergyString(recipe)))) {
            Objects.requireNonNull(mc.f_91062_);
            if (mouseY < (double)(50 + 9)) {
                return List.of(MachineLang.TOOLTIP_ENERGY_EQUIVALENCE);
            }
        }
        return List.of();
    }
}

