/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.menu;

import com.enderio.machines.common.blockentity.EnchanterBlockEntity;
import com.enderio.machines.common.init.MachineMenus;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.MachineMenu;
import com.enderio.machines.common.menu.MachineSlot;
import com.enderio.machines.common.recipe.EnchanterRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class EnchanterMenu
extends MachineMenu<EnchanterBlockEntity> {
    public static int INPUTS_INDEX = 0;
    public static int INPUT_COUNT = 3;
    public static int LAST_INDEX = 3;

    public EnchanterMenu(@Nullable EnchanterBlockEntity blockEntity, Inventory inventory, int pContainerId) {
        super(blockEntity, inventory, (MenuType)MachineMenus.ENCHANTER.get(), pContainerId);
        if (blockEntity != null) {
            this.m_38897_((Slot)new MachineSlot(blockEntity.getInventory(), EnchanterBlockEntity.BOOK, 16, 35));
            this.m_38897_((Slot)new MachineSlot(blockEntity.getInventory(), EnchanterBlockEntity.CATALYST, 65, 35));
            this.m_38897_((Slot)new MachineSlot(blockEntity.getInventory(), EnchanterBlockEntity.LAPIS, 85, 35));
            this.m_38897_((Slot)new EnchanterOutputMachineSlot(blockEntity, EnchanterBlockEntity.OUTPUT, 144, 35));
        }
        this.addInventorySlots(8, 84);
    }

    public static EnchanterMenu factory(@Nullable MenuType<EnchanterMenu> pMenuType, int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        BlockEntity entity = inventory.f_35978_.m_9236_().m_7702_(buf.m_130135_());
        if (entity instanceof EnchanterBlockEntity) {
            EnchanterBlockEntity castBlockEntity = (EnchanterBlockEntity)entity;
            return new EnchanterMenu(castBlockEntity, inventory, pContainerId);
        }
        LogManager.getLogger().warn("couldn't find BlockEntity");
        return new EnchanterMenu(null, inventory, pContainerId);
    }

    public int getCurrentCost() {
        EnchanterRecipe recipe = ((EnchanterBlockEntity)this.getBlockEntity()).getCurrentRecipe();
        if (recipe != null) {
            return recipe.getXPCost((Container)new RecipeWrapper((IItemHandlerModifiable)((EnchanterBlockEntity)this.getBlockEntity()).getInventory()));
        }
        return -1;
    }

    public class EnchanterOutputMachineSlot
    extends MachineSlot {
        @Nullable
        private final EnchanterBlockEntity blockEntity;

        public EnchanterOutputMachineSlot(EnchanterBlockEntity blockEntity, SingleSlotAccess access, int xPosition, int yPosition) {
            super(blockEntity.getInventory(), access, xPosition, yPosition);
            this.blockEntity = blockEntity;
        }

        public void m_142406_(Player pPlayer, ItemStack pStack) {
            EnchanterRecipe recipe = this.blockEntity.getCurrentRecipe();
            if (recipe != null && (pPlayer.f_36078_ >= recipe.getXPCost((Container)this.blockEntity.getContainer()) || pPlayer.m_7500_())) {
                int amount = recipe.getInputAmountConsumed((Container)this.blockEntity.getContainer());
                int lapizForLevel = recipe.getLapisForLevel(recipe.getEnchantmentLevel(EnchanterBlockEntity.CATALYST.getItemStack(this.blockEntity).m_41613_()));
                pPlayer.m_6749_(-recipe.getXPCost((Container)this.blockEntity.getContainer()));
                EnchanterBlockEntity.BOOK.getItemStack(this.blockEntity).m_41774_(1);
                EnchanterBlockEntity.CATALYST.getItemStack(this.blockEntity).m_41774_(amount);
                EnchanterBlockEntity.LAPIS.getItemStack(this.blockEntity).m_41774_(lapizForLevel);
                super.m_142406_(pPlayer, pStack);
            }
        }

        @Override
        public boolean m_8010_(Player playerIn) {
            EnchanterRecipe recipe = this.blockEntity.getCurrentRecipe();
            if (recipe != null && (playerIn.f_36078_ >= recipe.getXPCost((Container)this.blockEntity.getContainer()) || playerIn.m_7500_()) && this.blockEntity.canAct()) {
                return super.m_8010_(playerIn);
            }
            return false;
        }
    }
}

