ServerEvents.recipes(event => {

    const add_sieve = function (input, output, chance, mesh_tier, multip) {
        event.custom({
            "type": "exdeorum:sieve",
            "ingredient": {
                "item": input
            },
            "mesh": mesh_tier,
            "result": output,
            "result_amount": {
                "type": "minecraft:binomial",
                "n": 1.0,
                "p": chance * multip
            }
        });
    };

    const podzol_results = {
        'minecraft:oak_sapling': 0.03,
        'tconstruct:earth_slime_sapling': 0.01,
        'tconstruct:sky_slime_sapling': 0.01,
        'minecraft:slime_ball': 0.01,
        'tconstruct:sky_slime_ball': 0.01,
        'minecraft:cherry_sapling': 0.02,
        'minecraft:acacia_sapling': 0.02,
        'minecraft:dark_oak_sapling': 0.02,
        'pamhc2trees:apple_sapling': 0.01,
        'pamhc2trees:avocado_sapling': 0.01,
        'pamhc2trees:candlenut_sapling': 0.01,
        'pamhc2trees:cherry_sapling': 0.01,
        'pamhc2trees:chestnut_sapling': 0.01,
        'pamhc2trees:gooseberry_sapling': 0.01,
        'pamhc2trees:lemon_sapling': 0.01,
        'pamhc2trees:nutmeg_sapling': 0.01,
        'pamhc2trees:orange_sapling': 0.01,
        'pamhc2trees:peach_sapling': 0.01,
        'pamhc2trees:pear_sapling': 0.01,
        'pamhc2trees:plum_sapling': 0.01,
        'pamhc2trees:walnut_sapling': 0.01,
        'pamhc2trees:spiderweb_sapling': 0.01,
        'pamhc2trees:hazelnut_sapling': 0.01,
        'pamhc2trees:pawpaw_sapling': 0.01,
        'pamhc2trees:soursop_sapling': 0.01,
        'pamhc2trees:acorn_sapling': 0.01,
        'pamhc2trees:almond_sapling': 0.01,
        'pamhc2trees:apricot_sapling': 0.01,
        'pamhc2trees:banana_sapling': 0.01,
        'pamhc2trees:cashew_sapling': 0.01,
        'pamhc2trees:cinnamon_sapling': 0.01,
        'pamhc2trees:coconut_sapling': 0.01,
        'pamhc2trees:date_sapling': 0.01,
        'pamhc2trees:dragonfruit_sapling': 0.01,
        'pamhc2trees:durian_sapling': 0.01,
        'pamhc2trees:fig_sapling': 0.01,
        'pamhc2trees:grapefruit_sapling': 0.01,
        'pamhc2trees:lime_sapling': 0.01,
        'pamhc2trees:mango_sapling': 0.01,
        'pamhc2trees:olive_sapling': 0.01,
        'pamhc2trees:papaya_sapling': 0.01,
        'pamhc2trees:paperbark_sapling': 0.01,
        'pamhc2trees:pecan_sapling': 0.01,
        'pamhc2trees:peppercorn_sapling': 0.01,
        'pamhc2trees:persimmon_sapling': 0.01,
        'pamhc2trees:pistachio_sapling': 0.01,
        'pamhc2trees:pomegranate_sapling': 0.01,
        'pamhc2trees:starfruit_sapling': 0.01,
        'pamhc2trees:vanillabean_sapling': 0.01,
        'pamhc2trees:breadfruit_sapling': 0.01,
        'pamhc2trees:guava_sapling': 0.01,
        'pamhc2trees:jackfruit_sapling': 0.01,
        'pamhc2trees:lychee_sapling': 0.01,
        'pamhc2trees:passionfruit_sapling': 0.01,
        'pamhc2trees:rambutan_sapling': 0.01,
        'pamhc2trees:tamarind_sapling': 0.01,
        'pamhc2trees:maple_sapling': 0.01,
        'minecraft:wheat_seeds': 0.001,
        'minecraft:pumpkin_seeds': 0.001,
        'minecraft:melon_seeds': 0.001,
        'minecraft:beetroot_seeds': 0.001,
        'exdeorum:grass_seeds': 0.001,
        'pamhc2crops:mustardseedsitem': 0.001,
        'pamhc2crops:sesameseedsitem': 0.001,
        'pamhc2crops:agaveseeditem': 0.001,
        'pamhc2crops:amaranthseeditem': 0.001,
        'pamhc2crops:arrowrootseeditem': 0.001,
        'pamhc2crops:artichokeseeditem': 0.001,
        'pamhc2crops:asparagusseeditem': 0.001,
        'pamhc2crops:barleyseeditem': 0.001,
        'pamhc2crops:beanseeditem': 0.001,
        'pamhc2crops:bellpepperseeditem': 0.001,
        'pamhc2crops:blackberryseeditem': 0.001,
        'pamhc2crops:blueberryseeditem': 0.001,
        'pamhc2crops:broccoliseeditem': 0.001,
        'pamhc2crops:brusselsproutseeditem': 0.001,
        'pamhc2crops:cabbageseeditem': 0.001,
        'pamhc2crops:cactusfruitseeditem': 0.001,
        'pamhc2crops:candleberryseeditem': 0.001,
        'pamhc2crops:cantaloupeseeditem': 0.001,
        'pamhc2crops:cassavaseeditem': 0.001,
        'pamhc2crops:cauliflowerseeditem': 0.001,
        'pamhc2crops:celeryseeditem': 0.001,
        'pamhc2crops:chickpeaseeditem': 0.001,
        'pamhc2crops:chilipepperseeditem': 0.001,
        'pamhc2crops:coffeebeanseeditem': 0.001,
        'pamhc2crops:cornseeditem': 0.001,
        'pamhc2crops:cottonseeditem': 0.001,
        'pamhc2crops:cranberryseeditem': 0.001,
        'pamhc2crops:cucumberseeditem': 0.001,
        'pamhc2crops:eggplantseeditem': 0.001,
        'pamhc2crops:elderberryseeditem': 0.001,
        'pamhc2crops:flaxseeditem': 0.001,
        'pamhc2crops:garlicseeditem': 0.001,
        'pamhc2crops:gingerseeditem': 0.001,
        'pamhc2crops:grapeseeditem': 0.001,
        'pamhc2crops:greengrapeseeditem': 0.001,
        'pamhc2crops:huckleberryseeditem': 0.001,
        'pamhc2crops:jicamaseeditem': 0.001,
        'pamhc2crops:juniperberryseeditem': 0.001,
        'pamhc2crops:juteseeditem': 0.001,
        'pamhc2crops:kaleseeditem': 0.001,
        'pamhc2crops:kenafseeditem': 0.001,
        'pamhc2crops:kiwiseeditem': 0.001,
        'pamhc2crops:kohlrabiseeditem': 0.001,
        'pamhc2crops:leekseeditem': 0.001,
        'pamhc2crops:lentilseeditem': 0.001,
        'pamhc2crops:lettuceseeditem': 0.001,
        'pamhc2crops:milletseeditem': 0.001,
        'pamhc2crops:mulberryseeditem': 0.001,
        'pamhc2crops:mustardseedsseeditem': 0.001,
        'pamhc2crops:oatsseeditem': 0.001,
        'pamhc2crops:okraseeditem': 0.001,
        'pamhc2crops:onionseeditem': 0.001,
        'pamhc2crops:parsnipseeditem': 0.001,
        'pamhc2crops:peanutseeditem': 0.001,
        'pamhc2crops:peasseeditem': 0.001,
        'pamhc2crops:pineappleseeditem': 0.001,
        'pamhc2crops:quinoaseeditem': 0.001,
        'pamhc2crops:radishseeditem': 0.001,
        'pamhc2crops:raspberryseeditem': 0.001,
        'pamhc2crops:rhubarbseeditem': 0.001,
        'pamhc2crops:riceseeditem': 0.001,
        'pamhc2crops:rutabagaseeditem': 0.001,
        'pamhc2crops:ryeseeditem': 0.001,
        'pamhc2crops:scallionseeditem': 0.001,
        'pamhc2crops:sesameseedsseeditem': 0.001,
        'pamhc2crops:sisalseeditem': 0.001,
        'pamhc2crops:soybeanseeditem': 0.001,
        'pamhc2crops:spiceleafseeditem': 0.001,
        'pamhc2crops:spinachseeditem': 0.001,
        'pamhc2crops:strawberryseeditem': 0.001,
        'pamhc2crops:sweetpotatoseeditem': 0.001,
        'pamhc2crops:taroseeditem': 0.001,
        'pamhc2crops:tealeafseeditem': 0.001,
        'pamhc2crops:tomatilloseeditem': 0.001,
        'pamhc2crops:tomatoseeditem': 0.001,
        'pamhc2crops:turnipseeditem': 0.001,
        'pamhc2crops:waterchestnutseeditem': 0.001,
        'pamhc2crops:whitemushroomseeditem': 0.001,
        'pamhc2crops:wintersquashseeditem': 0.001,
        'pamhc2crops:zucchiniseeditem': 0.001,
        'pamhc2crops:alfalfaseeditem': 0.001,
        'pamhc2crops:aloeseeditem': 0.001,
        'pamhc2crops:barrelcactusseeditem': 0.001,
        'pamhc2crops:canolaseeditem': 0.001,
        'pamhc2crops:cattailseeditem': 0.001,
        'pamhc2crops:chiaseeditem': 0.001,
        'pamhc2crops:cloudberryseeditem': 0.001,
        'pamhc2crops:lotusseeditem': 0.001,
        'pamhc2crops:nettlesseeditem': 0.001,
        'pamhc2crops:nopalesseeditem': 0.001,
        'pamhc2crops:sorghumseeditem': 0.001,
        'pamhc2crops:truffleseeditem': 0.001,
        'pamhc2crops:wolfberryseeditem': 0.001,
        'pamhc2crops:yuccaseeditem': 0.001,
        'pamhc2crops:bokchoyseeditem': 0.001,
        'pamhc2crops:calabashseeditem': 0.001,
        'pamhc2crops:guaranaseeditem': 0.001,
        'pamhc2crops:papyrusseeditem': 0.001,
        'pamhc2crops:sunchokeseeditem': 0.001
    };

    const mesh = {
        'exdeorum:string_mesh': 1,
        'exdeorum:flint_mesh': 1.2,
        'exdeorum:iron_mesh': 1.4,
        'exdeorum:golden_mesh': 1.6,
        'exdeorum:diamond_mesh': 1.8,
        'exdeorum:netherite_mesh': 2.0
    };

    for (const [output, chance] of Object.entries(podzol_results)) {
        for (const [mesh_tier, multip] of Object.entries(mesh)) {
            add_sieve('minecraft:podzol', output, chance, mesh_tier, multip);
        }
    }

});
