/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.stonecutterwand;

import com.mojang.logging.LogUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.ricmc.stonecutterwand.Config;
import net.ricmc.stonecutterwand.item.ModCreativeModeTabs;
import net.ricmc.stonecutterwand.item.ModItems;
import net.ricmc.stonecutterwand.item.custom.ModDataComponents;
import net.ricmc.stonecutterwand.item.custom.VariantGroupCache;
import org.slf4j.Logger;

@Mod(value="stonecutterwand")
public class StonecutterWand {
    public static final String MOD_ID = "stonecutterwand";
    public static final Logger LOGGER = LogUtils.getLogger();

    public StonecutterWand(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModDataComponents.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (((Boolean)Config.DISABLE_VARIANT_WAND.get()).booleanValue()) {
            LOGGER.warn("Config says to disable the Variant Wand... but I refuse. It's all I have.");
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(ModItems.VARIANT_WAND);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        ServerLevel level = event.getServer().overworld();
        VariantGroupCache.build(event.getServer().getRecipeManager(), (Level)level);
    }

    @EventBusSubscriber(modid="stonecutterwand", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

