/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.stonecutterwand.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.ricmc.stonecutterwand.item.custom.ModDataComponents;
import net.ricmc.stonecutterwand.item.custom.VariantGroupCache;
import org.jetbrains.annotations.NotNull;

public class VariantCyclerWand
extends Item {
    public VariantCyclerWand(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ResourceLocation id;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState clickedState = level.getBlockState(pos);
        Block clickedBlock = clickedState.getBlock();
        if (player == null) {
            return InteractionResult.PASS;
        }
        boolean isSneaking = player.isShiftKeyDown();
        boolean hasBound = stack.has((DataComponentType)ModDataComponents.BOUND_BLOCK.get());
        if (isSneaking && !hasBound && (id = BuiltInRegistries.BLOCK.getKey((Object)clickedBlock)) != null && clickedBlock != Blocks.AIR) {
            stack.set((DataComponentType)ModDataComponents.BOUND_BLOCK.get(), (Object)id);
            if (clickedState.hasProperty((Property)StairBlock.FACING) && clickedState.hasProperty((Property)StairBlock.HALF) && clickedState.hasProperty((Property)StairBlock.SHAPE)) {
                String orientation = ((Direction)clickedState.getValue((Property)StairBlock.FACING)).getName() + ":" + ((Half)clickedState.getValue((Property)StairBlock.HALF)).getSerializedName() + ":" + ((StairsShape)clickedState.getValue((Property)StairBlock.SHAPE)).getSerializedName();
                stack.set((DataComponentType)ModDataComponents.BOUND_ORIENTATION.get(), (Object)orientation);
            }
            if (level.isClientSide) {
                Component name = VariantCyclerWand.getBoundBlockName(stack);
                player.displayClientMessage((Component)Component.translatable((String)"item.stonecutterwand.bound_prefix", (Object[])new Object[]{name}), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (hasBound) {
            Component name;
            String[] parts;
            ResourceLocation boundId = (ResourceLocation)stack.get((DataComponentType)ModDataComponents.BOUND_BLOCK.get());
            Block boundBlock = (Block)BuiltInRegistries.BLOCK.get(boundId);
            List<Block> group = VariantGroupCache.getGroup(clickedBlock);
            BlockState boundState = boundBlock.defaultBlockState();
            String storedOrientation = (String)stack.get((DataComponentType)ModDataComponents.BOUND_ORIENTATION.get());
            if (storedOrientation != null && (parts = storedOrientation.split(":")).length == 3 && boundState.hasProperty((Property)StairBlock.FACING) && boundState.hasProperty((Property)StairBlock.HALF) && boundState.hasProperty((Property)StairBlock.SHAPE)) {
                Direction facing = Direction.byName((String)parts[0]);
                Half half = Half.valueOf((String)parts[1].toUpperCase());
                StairsShape shape = StairsShape.valueOf((String)parts[2].toUpperCase());
                boundState = (BlockState)((BlockState)((BlockState)boundState.setValue((Property)StairBlock.FACING, (Comparable)facing)).setValue((Property)StairBlock.HALF, (Comparable)half)).setValue((Property)StairBlock.SHAPE, (Comparable)shape);
            }
            if (level.getBlockState(pos).equals(boundState)) {
                if (level.isClientSide) {
                    name = VariantCyclerWand.getBoundBlockName(stack);
                    player.displayClientMessage((Component)Component.translatable((String)"item.stonecutterwand.already_bound", (Object[])new Object[]{name}), true);
                }
                return InteractionResult.FAIL;
            }
            if (group != null && group.contains(boundBlock)) {
                String[] parts2;
                BlockState originalState = level.getBlockState(pos);
                BlockState newState = boundBlock.defaultBlockState();
                for (Property property : originalState.getProperties()) {
                    if (!newState.hasProperty(property)) continue;
                    newState = VariantCyclerWand.copyProperty(newState, originalState, property);
                }
                String orientation = (String)stack.get((DataComponentType)ModDataComponents.BOUND_ORIENTATION.get());
                if (orientation != null && (parts2 = orientation.split(":")).length == 3 && newState.hasProperty((Property)StairBlock.FACING) && newState.hasProperty((Property)StairBlock.HALF) && newState.hasProperty((Property)StairBlock.SHAPE)) {
                    Direction facing = Direction.byName((String)parts2[0]);
                    Half half = Half.valueOf((String)parts2[1].toUpperCase());
                    StairsShape shape = StairsShape.valueOf((String)parts2[2].toUpperCase());
                    newState = (BlockState)((BlockState)((BlockState)newState.setValue((Property)StairBlock.FACING, (Comparable)facing)).setValue((Property)StairBlock.HALF, (Comparable)half)).setValue((Property)StairBlock.SHAPE, (Comparable)shape);
                }
                level.setBlock(pos, newState, 3);
                level.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.isClientSide()) {
                    stack.hurtAndBreak(1, (ServerLevel)level, (LivingEntity)player, item -> player.onEquippedItemBroken(item, context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
                }
                return InteractionResult.SUCCESS;
            }
            if (level.isClientSide) {
                name = VariantCyclerWand.getBoundBlockName(stack);
                player.displayClientMessage((Component)Component.translatable((String)"item.stonecutterwand.cannot_apply", (Object[])new Object[]{name}), true);
            }
            return InteractionResult.FAIL;
        }
        if (VariantGroupCache.tryCycle(level, pos, player)) {
            level.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide()) {
                stack.hurtAndBreak(1, (ServerLevel)level, (LivingEntity)player, item -> player.onEquippedItemBroken(item, context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            stack.remove(ModDataComponents.BOUND_BLOCK);
            stack.remove(ModDataComponents.BOUND_ORIENTATION);
            if (level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"item.stonecutterwand.bound_cleared"), true);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        if (stack.has((DataComponentType)ModDataComponents.BOUND_BLOCK.get())) {
            ResourceLocation boundId;
            Block boundBlock;
            List<Block> group;
            Component name = VariantCyclerWand.getBoundBlockName(stack);
            tooltipComponents.add((Component)Component.translatable((String)"item.stonecutterwand.tooltip.bound", (Object[])new Object[]{name}).withStyle(style -> style.withItalic(Boolean.valueOf(true)).withColor(0xAAAAAA)));
            tooltipComponents.add((Component)Component.translatable((String)"item.stonecutterwand.tooltip.unbind").withStyle(style -> style.withItalic(Boolean.valueOf(true))));
            if (stack.has((DataComponentType)ModDataComponents.BOUND_ORIENTATION.get())) {
                tooltipComponents.add((Component)Component.literal((String)("\u00a78Orientation: " + (String)stack.get((DataComponentType)ModDataComponents.BOUND_ORIENTATION.get()))).withStyle(style -> style.withItalic(Boolean.valueOf(true))));
            }
            if ((group = VariantGroupCache.getGroup(boundBlock = (Block)BuiltInRegistries.BLOCK.get(boundId = (ResourceLocation)stack.get((DataComponentType)ModDataComponents.BOUND_BLOCK.get())))) != null && !group.isEmpty()) {
                tooltipComponents.add((Component)Component.translatable((String)"item.stonecutterwand.tooltip.variant_count", (Object[])new Object[]{group.size()}).withStyle(style -> style.withColor(0xAAAAAA)));
                if (Screen.hasShiftDown()) {
                    tooltipComponents.add((Component)Component.translatable((String)"item.stonecutterwand.tooltip.variant_list").withStyle(style -> style.withItalic(Boolean.valueOf(true))));
                    for (Block variant : group) {
                        tooltipComponents.add((Component)Component.literal((String)("\u00a77 - " + variant.getName().getString())).withStyle(style -> style.withColor(0xCCCCCC)));
                    }
                } else {
                    tooltipComponents.add((Component)Component.translatable((String)"item.stonecutterwand.tooltip.hold_shift").withStyle(style -> style.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.YELLOW)));
                }
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.stonecutterwand.tooltip.cycle_mode").withStyle(style -> style.withColor(0xAAAAAA)));
            tooltipComponents.add((Component)Component.translatable((String)"item.stonecutterwand.tooltip.bind").withStyle(style -> style.withItalic(Boolean.valueOf(true))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private static Component getBoundBlockName(ItemStack stack) {
        if (!stack.has((DataComponentType)ModDataComponents.BOUND_BLOCK.get())) {
            return Component.translatable((String)"item.stonecutterwand.name.none");
        }
        ResourceLocation id = (ResourceLocation)stack.get((DataComponentType)ModDataComponents.BOUND_BLOCK.get());
        Block block = (Block)BuiltInRegistries.BLOCK.get(id);
        if (block == null || block == Blocks.AIR) {
            return Component.translatable((String)"item.stonecutterwand.name.unknown", (Object[])new Object[]{id.toString()});
        }
        return block.getName();
    }

    private static BlockState copyProperty(BlockState target, BlockState source, Property<?> rawProperty) {
        try {
            return (BlockState)target.setValue(rawProperty, source.getValue(rawProperty));
        }
        catch (Exception e) {
            return target;
        }
    }
}

