/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.stonecutterwand.item.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class VariantGroupCache {
    private static final Map<Block, List<Block>> variantGroups = new HashMap<Block, List<Block>>();

    public static void build(RecipeManager recipeManager, Level level) {
        RegistryAccess registryAccess = level.registryAccess();
        HashMap<Block, List> rawGroups = new HashMap<Block, List>();
        for (RecipeHolder holder : recipeManager.getAllRecipesFor(RecipeType.STONECUTTING)) {
            Object inputs;
            StonecutterRecipe stonecutterRecipe = (StonecutterRecipe)holder.value();
            Ingredient ingredient = (Ingredient)stonecutterRecipe.getIngredients().get(0);
            ItemStack output = stonecutterRecipe.getResultItem((HolderLookup.Provider)registryAccess);
            if (ingredient.isEmpty() || output.isEmpty() || ((ItemStack[])(inputs = ingredient.getItems())).length == 0) continue;
            Block block = Block.byItem((Item)inputs[0].getItem());
            Block outputBlock = Block.byItem((Item)output.getItem());
            if (block == Blocks.AIR || outputBlock == Blocks.AIR) continue;
            rawGroups.computeIfAbsent(block, k -> new ArrayList()).add(outputBlock);
        }
        HashSet mergedGroups = new HashSet();
        for (Map.Entry entry : rawGroups.entrySet()) {
            HashSet<Block> newGroup = new HashSet<Block>();
            newGroup.add((Block)entry.getKey());
            newGroup.addAll((Collection)entry.getValue());
            Set merged = null;
            for (Set set : mergedGroups) {
                if (Collections.disjoint(set, newGroup)) continue;
                merged = set;
                break;
            }
            if (merged != null) {
                merged.addAll(newGroup);
                continue;
            }
            mergedGroups.add(newGroup);
        }
        for (Set set : mergedGroups) {
            List<Block> ordered = set.stream().sorted(Comparator.comparing(b -> VariantGroupCache.extractSortableName(b))).toList();
            for (Block b2 : set) {
                variantGroups.put(b2, ordered);
            }
        }
        System.out.println("[StonecutterWand] Built " + variantGroups.size() + " variant groups.");
    }

    private static String extractSortableName(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (id == null) {
            return block.getName().getString();
        }
        return id.getNamespace() + ":" + VariantGroupCache.padNumbers(id.getPath());
    }

    private static String padNumbers(String input) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = Pattern.compile("\\d+").matcher(input);
        int lastEnd = 0;
        while (matcher.find()) {
            result.append(input, lastEnd, matcher.start());
            String padded = String.format("%05d", Integer.parseInt(matcher.group()));
            result.append(padded);
            lastEnd = matcher.end();
        }
        result.append(input.substring(lastEnd));
        return result.toString();
    }

    public static List<Block> getGroup(Block block) {
        return variantGroups.getOrDefault(block, Collections.emptyList());
    }

    public static boolean isEmpty() {
        return variantGroups.isEmpty();
    }

    public static boolean tryCycle(Level level, BlockPos pos, Player player) {
        BlockState currentState = level.getBlockState(pos);
        Block currentBlock = currentState.getBlock();
        List<Block> group = VariantGroupCache.getGroup(currentBlock);
        if (group == null || group.size() < 2) {
            if (player != null && level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"message.stonecutterwand.no_variants"), true);
            }
            return false;
        }
        int index = group.indexOf(currentBlock);
        Block nextBlock = group.get((index + 1) % group.size());
        BlockState newState = nextBlock.defaultBlockState();
        level.setBlock(pos, newState, 3);
        return true;
    }
}

