/*
 * Decompiled with CFR 0.152.
 */
package com.kasetoatz.dacl.options.validators;

import com.kasetoatz.dacl.options.validators.AbstractValidator;
import net.minecraft.class_2561;

public class RangeValidator<T extends Number>
extends AbstractValidator<T> {
    private final T min;
    private final T max;

    public RangeValidator(T minInclusive, T maxInclusive) {
        if (minInclusive == null && maxInclusive == null) {
            throw new IllegalArgumentException("Min and max cannot both be null");
        }
        if (minInclusive != null && maxInclusive != null && ((Comparable)minInclusive).compareTo(maxInclusive) > 0) {
            throw new IllegalArgumentException("Min cannot be greater than max");
        }
        this.min = minInclusive;
        this.max = maxInclusive;
    }

    @Override
    public boolean isValid(T value) {
        return !(this.min != null && ((Comparable)value).compareTo(this.min) <= 0 || this.max != null && ((Comparable)value).compareTo(this.max) >= 0);
    }

    @Override
    public String getErrorMessage() {
        if (this.min == null && this.max != null) {
            return class_2561.method_43469((String)"dacl.range.smaller", (Object[])new Object[]{this.max}).getString();
        }
        if (this.min != null && this.max == null) {
            return class_2561.method_43469((String)"dacl.range.larger", (Object[])new Object[]{this.min}).getString();
        }
        return class_2561.method_43469((String)"dacl.range.between", (Object[])new Object[]{this.min, this.max}).getString();
    }
}

