/*
 * Decompiled with CFR 0.152.
 */
package com.kasetoatz.dacl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kasetoatz.dacl.options.AbstractInputOption;
import com.kasetoatz.dacl.options.AbstractOption;
import com.kasetoatz.dacl.ui.ConfigScreen;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class DumbassConfig {
    public static int TEXT_LEFT = 20;
    public static int TEXT_WIDTH = 200;
    public static int TEXT_HEIGHT = 40;
    public static int OPTION_RIGHT = 100;
    public static int OPTION_WIDTH = 80;
    public static int OPTION_HEIGHT = 40;
    public static int ENTRY_HEIGHT = 50;
    public static int DONE_BUTTON_WIDTH = 200;
    public static int BOOLEAN_TRUE_COLOR = 65280;
    public static int BOOLEAN_FALSE_COLOR = 0xFF0000;
    public static int VALID_INPUT_COLOR = -1;
    public static int INVALID_INPUT_COLOR = -65536;
    public static int BACKGROUND_COLOR_1 = 0x50555555;
    public static int BACKGROUND_COLOR_2 = 0x50333333;
    private final ArrayList<AbstractOption<?>> options = new ArrayList();
    private ConfigScreen ui;
    private final Path file;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private DumbassConfig(String filename) {
        this.file = FabricLoader.getInstance().getConfigDir().resolve((String)(filename.endsWith(".json") ? filename : filename + ".json"));
    }

    public class_437 getUI(class_437 parent) {
        this.ui.setParent(parent);
        return this.ui;
    }

    private void load() {
        if (!Files.exists(this.file, new LinkOption[0])) {
            this.save();
            return;
        }
        try {
            String json = Files.readString(this.file);
            JsonObject data = (JsonObject)this.gson.fromJson(json, JsonObject.class);
            for (AbstractOption<?> option : this.options) {
                AbstractInputOption inputOption;
                if (!data.has(option.getKey())) continue;
                JsonElement value = data.get(option.getKey());
                if (option instanceof AbstractInputOption && !(inputOption = (AbstractInputOption)option).isValid(value)) {
                    option.reset();
                    continue;
                }
                option.fromJson(data.get(option.getKey()));
            }
            this.save();
        }
        catch (IOException exc) {
            throw new class_148(class_128.method_560((Throwable)exc, (String)"Loading config file."));
        }
    }

    public void save() {
        try {
            JsonObject data = new JsonObject();
            for (AbstractOption<?> option : this.options) {
                data.add(option.getKey(), this.gson.toJsonTree(option.getValue()));
            }
            Files.writeString(this.file, (CharSequence)this.gson.toJson((JsonElement)data), new OpenOption[0]);
        }
        catch (IOException exc) {
            throw new class_148(class_128.method_560((Throwable)exc, (String)"Saving config file."));
        }
    }

    public static Builder builder(class_2561 uiTitle, String filename) {
        return new Builder(uiTitle, filename);
    }

    public static class Builder {
        private final DumbassConfig config;
        private final class_2561 uiTitle;

        private Builder(class_2561 uiTitle, String filename) {
            this.config = new DumbassConfig(filename);
            this.uiTitle = uiTitle;
        }

        public Builder withOption(AbstractOption<?> option) {
            this.config.options.add(option);
            return this;
        }

        public DumbassConfig build() {
            this.config.load();
            this.config.ui = new ConfigScreen(this.uiTitle, this.config.options);
            this.config.ui.setSaveCallback(this.config::save);
            return this.config;
        }
    }
}

