/*
 * Decompiled with CFR 0.152.
 */
package com.kasetoatz.dacl.options;

import com.google.gson.JsonElement;
import com.kasetoatz.dacl.options.AbstractInputOption;
import com.kasetoatz.dacl.options.validators.AbstractValidator;
import net.minecraft.class_2561;

public class FloatOption
extends AbstractInputOption<Float> {
    public FloatOption(class_2561 text, String key, Float defaultValue, AbstractValidator<Float> validator) {
        super(text, key, defaultValue, validator);
    }

    public FloatOption(class_2561 text, String key, Float defaultValue) {
        super(text, key, defaultValue);
    }

    @Override
    public boolean predicate(String text) {
        if (text.isEmpty() || text.equals(".") || text.equals("-")) {
            return true;
        }
        try {
            Float.parseFloat(text);
            return true;
        }
        catch (NumberFormatException exc) {
            return false;
        }
    }

    @Override
    public void changeListener(String text) {
        this.onChange(Float.valueOf(text.isEmpty() || text.equals(".") || text.equals("-") ? 0.0f : Float.parseFloat(text)));
    }

    @Override
    public Float asPrimitive(JsonElement element) {
        return Float.valueOf(element.getAsFloat());
    }
}

