/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.mojang.brigadier.CommandDispatcher;
import com.turtlehoarder.cobblemonchallenge.common.CobblemonChallengeCommonInterface;
import com.turtlehoarder.cobblemonchallenge.common.command.ChallengeCommand;
import com.turtlehoarder.cobblemonchallenge.common.validation.ChallengeTeamValidator;
import com.turtlehoarder.cobblemonchallenge.common.validation.validators.BlacklistValidator;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.List;
import kotlin.Unit;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobblemonChallenge {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cobblemonchallenge");
    public static final String MODID = "cobblemonchallenge";
    public static Boolean CHALLENGE_DISTANCE_RESTRICTION;
    public static int MAX_CHALLENGE_DISTANCE;
    public static int DEFAULT_CHALLENGE_LEVEL;
    public static int DEFAULT_HANDICAP;
    public static int REQUEST_EXPIRATION_MILLIS;
    public static int CHALLENGE_COOLDOWN_MILLIS;
    public static ChallengeTeamValidator TEAM_VALIDATOR;
    public static final String CHALLENGE_DISTANCE_CONFIG_NAME = "challengeDistanceRestriction";
    public static final String MAX_CHALLENGE_DISTANCE_CONFIG_NAME = "maxChallengeDistance";
    public static final String DEFAULT_CHALLENGE_LEVEL_CONFIG_NAME = "defaultChallengeLevel";
    public static final String DEFAULT_HANDICAP_CONFIG_NAME = "defaultHandicap";
    public static final String CHALLENGE_EXPIRATION_TIME_CONFIG_NAME = "challengeExpirationTime";
    public static final String CHALLENGE_COOLDOWN_CONFIG_NAME = "challengeCooldownTime";
    private CobblemonChallengeCommonInterface implementation;

    public void initializeChallenge(CobblemonChallengeCommonInterface implementation) {
        this.implementation = implementation;
        CHALLENGE_DISTANCE_RESTRICTION = implementation.getBooleanConfig(CHALLENGE_DISTANCE_CONFIG_NAME);
        MAX_CHALLENGE_DISTANCE = implementation.getIntConfig(MAX_CHALLENGE_DISTANCE_CONFIG_NAME);
        DEFAULT_CHALLENGE_LEVEL = implementation.getIntConfig(DEFAULT_CHALLENGE_LEVEL_CONFIG_NAME);
        DEFAULT_HANDICAP = implementation.getIntConfig(DEFAULT_HANDICAP_CONFIG_NAME);
        REQUEST_EXPIRATION_MILLIS = implementation.getIntConfig(CHALLENGE_EXPIRATION_TIME_CONFIG_NAME);
        CHALLENGE_COOLDOWN_MILLIS = implementation.getIntConfig(CHALLENGE_COOLDOWN_CONFIG_NAME);
        TEAM_VALIDATOR = implementation.createTeamValidator();
        implementation.registerCommands();
        implementation.registerEvents();
        PlatformEvents.SERVER_STARTING.subscribe(Priority.NORMAL, starting -> {
            TEAM_VALIDATOR.onServerStart();
            return Unit.INSTANCE;
        });
        List<class_2960> bannedWorlds = BlacklistValidator.parseList("bannedWorlds", class_2960::method_12829, TEAM_VALIDATOR.getConfigString("bannedWorlds", "[]"));
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.HIGHEST, event -> {
            if (bannedWorlds.contains(event.getCtx().getWorld().method_27983().method_29177())) {
                event.cancel();
            }
            return Unit.INSTANCE;
        });
    }

    public static void registerCommands() {
        CommandRegistrationEvent.EVENT.register((commandDispatcher, commandBuildContext, commandSelection) -> ChallengeCommand.register((CommandDispatcher<class_2168>)commandDispatcher));
    }
}

