/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common.battle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.net.messages.client.storage.party.InitializePartyPacket;
import com.turtlehoarder.cobblemonchallenge.common.battle.ChallengeFormat;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_3222;
import net.minecraft.class_5455;

public class FakePartyAccessor
implements Function1<class_3222, PartyStore> {
    private List<Integer> player1Selection;
    private List<Integer> player2Selection;
    private class_3222 player1;
    private class_3222 player2;
    private ChallengeFormat format;

    public FakePartyAccessor(List<Integer> player1Selection, List<Integer> player2Selection, class_3222 player1, class_3222 player2, ChallengeFormat format) {
        this.player1Selection = player1Selection;
        this.player2Selection = player2Selection;
        this.player1 = player1;
        this.player2 = player2;
        this.format = format;
    }

    private List<Integer> getSelectionForThisPlayer(class_3222 player) {
        if (player == this.player1) {
            return this.player1Selection;
        }
        return this.player2Selection;
    }

    public PartyStore invoke(class_3222 serverPlayer) {
        PlayerPartyStore originalPartyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
        UUID challengeBattleStoreUUID = UUID.randomUUID();
        PartyStore challengeBattleStore = new PartyStore(challengeBattleStoreUUID);
        CobblemonNetwork.INSTANCE.sendPacketToPlayer(serverPlayer, (NetworkPacket)new InitializePartyPacket(false, challengeBattleStoreUUID, this.format.getTotalPokemonSlots()));
        challengeBattleStore.setObserverUUIDs(List.of(serverPlayer.method_5667()));
        Set store = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toSet());
        List<Integer> slotSelection = this.getSelectionForThisPlayer(serverPlayer);
        class_5455.class_6890 registryAccess = serverPlayer.method_5682().method_30611();
        for (int slotSelected : slotSelection) {
            challengeBattleStore.add(originalPartyStore.get(slotSelected).clone(true, (class_5455)registryAccess));
            store.remove(slotSelected);
        }
        if (this.format.getTotalPokemonSlots() > this.format.getTotalPokemonSelected()) {
            for (int remainingSlot : store) {
                if (originalPartyStore.get(remainingSlot) == null) continue;
                challengeBattleStore.add(originalPartyStore.get(remainingSlot).clone(true, (class_5455)registryAccess));
            }
        }
        return challengeBattleStore;
    }
}

