/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common.command;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.turtlehoarder.cobblemonchallenge.common.CobblemonChallenge;
import com.turtlehoarder.cobblemonchallenge.common.battle.ChallengeFormat;
import com.turtlehoarder.cobblemonchallenge.common.gui.LeadPokemonSelectionSession;
import com.turtlehoarder.cobblemonchallenge.common.util.ChallengeUtil;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ChallengeCommand {
    private static final float MAX_DISTANCE = CobblemonChallenge.MAX_CHALLENGE_DISTANCE;
    private static final boolean USE_DISTANCE_RESTRICTION = CobblemonChallenge.CHALLENGE_DISTANCE_RESTRICTION;
    private static final int DEFAULT_LEVEL = CobblemonChallenge.DEFAULT_CHALLENGE_LEVEL;
    private static final int CHALLENGE_COOLDOWN = CobblemonChallenge.CHALLENGE_COOLDOWN_MILLIS;
    public static HashMap<String, ChallengeRequest> CHALLENGE_REQUESTS = new HashMap();
    public static final HashMap<UUID, LeadPokemonSelection> ACTIVE_SELECTIONS = new HashMap();
    private static final HashMap<UUID, Long> LAST_SENT_CHALLENGE = new HashMap();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        ChallengeCommand.registerChallengeFormatCommand(dispatcher, "challenge", ChallengeFormat.STANDARD_6V6);
        ChallengeCommand.registerChallengeFormatCommand(dispatcher, "challenge1v1", ChallengeFormat.STANDARD_1V1);
        ChallengeCommand.registerChallengeFormatCommand(dispatcher, "challenge2v2", ChallengeFormat.STANDARD_2V2);
        ChallengeCommand.registerChallengeFormatCommand(dispatcher, "challenge3v3", ChallengeFormat.STANDARD_3V3);
        ChallengeCommand.registerChallengeFormatCommand(dispatcher, "challenge4v4", ChallengeFormat.STANDARD_4V4);
        ChallengeCommand.registerChallengeFormatCommand(dispatcher, "challenge5v5", ChallengeFormat.STANDARD_5V5);
        ChallengeCommand.registerChallengeFormatCommand(dispatcher, "challenge6v6", ChallengeFormat.STANDARD_6V6);
        ChallengeCommand.registerChallengeFormatCommand(dispatcher, "challengedouble", ChallengeFormat.STANDARD_DOUBLES_6V6);
        ChallengeCommand.registerAcceptDenyCommands(dispatcher);
    }

    private static void registerAcceptDenyCommands(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder commandBuilderAcceptChallenge = (LiteralArgumentBuilder)class_2170.method_9247((String)"acceptchallenge").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(c -> ChallengeCommand.acceptChallenge((CommandContext<class_2168>)c, StringArgumentType.getString((CommandContext)c, (String)"id"))));
        LiteralArgumentBuilder commandBuilderRejectChallenge = (LiteralArgumentBuilder)class_2170.method_9247((String)"rejectchallenge").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(c -> ChallengeCommand.rejectChallenge((CommandContext<class_2168>)c, StringArgumentType.getString((CommandContext)c, (String)"id"))));
        dispatcher.register(commandBuilderAcceptChallenge);
        dispatcher.register(commandBuilderRejectChallenge);
    }

    private static void registerChallengeFormatCommand(CommandDispatcher<class_2168> dispatcher, String baseCommand, ChallengeFormat resultingFormat) {
        LiteralArgumentBuilder baseCommandBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)baseCommand).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> ChallengeCommand.challengePlayer((CommandContext<class_2168>)c, DEFAULT_LEVEL, true, resultingFormat)));
        LiteralArgumentBuilder baseCommandBuilderNoPreview = (LiteralArgumentBuilder)class_2170.method_9247((String)baseCommand).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"nopreview").executes(c -> ChallengeCommand.challengePlayer((CommandContext<class_2168>)c, DEFAULT_LEVEL, false, resultingFormat))));
        LiteralArgumentBuilder commandBuilderWithLevelOption = (LiteralArgumentBuilder)class_2170.method_9247((String)baseCommand).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"setLevelTo", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(c -> ChallengeCommand.challengePlayer((CommandContext<class_2168>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"setLevelTo"), true, resultingFormat)))));
        LiteralArgumentBuilder commandBuilderWithLevelOptionNoPreview = (LiteralArgumentBuilder)class_2170.method_9247((String)baseCommand).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"setLevelTo", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).then(class_2170.method_9247((String)"nopreview").executes(c -> ChallengeCommand.challengePlayer((CommandContext<class_2168>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"setLevelTo"), false, resultingFormat))))));
        LiteralArgumentBuilder commandBuilderWithLevelOptionNoPreviewBefore = (LiteralArgumentBuilder)class_2170.method_9247((String)baseCommand).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"nopreview").then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"setLevelTo", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(c -> ChallengeCommand.challengePlayer((CommandContext<class_2168>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"setLevelTo"), false, resultingFormat))))));
        dispatcher.register(commandBuilderWithLevelOption);
        dispatcher.register(commandBuilderWithLevelOptionNoPreview);
        dispatcher.register(baseCommandBuilderNoPreview);
        dispatcher.register(commandBuilderWithLevelOptionNoPreviewBefore);
        dispatcher.register(baseCommandBuilder);
    }

    public static int challengePlayer(CommandContext<class_2168> c, int level, boolean preview, ChallengeFormat format) {
        try {
            class_3222 challengerPlayer = ((class_2168)c.getSource()).method_44023();
            class_3222 challengedPlayer = ((class_2300)c.getArgument("player", class_2300.class)).method_9811((class_2168)c.getSource());
            if (LAST_SENT_CHALLENGE.containsKey(challengerPlayer.method_5667()) && System.currentTimeMillis() - LAST_SENT_CHALLENGE.get(challengerPlayer.method_5667()) < (long)CHALLENGE_COOLDOWN) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)String.format("You must wait at least %d second(s) before sending another challenge", (int)Math.ceil((float)CHALLENGE_COOLDOWN / 1000.0f))));
                return 0;
            }
            for (ChallengeRequest request : CHALLENGE_REQUESTS.values()) {
                if (!request.challengerPlayer.method_5667().equals(challengerPlayer.method_5667())) continue;
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)String.format("You already have a pending challenge to %s", request.challengedPlayer.method_5476().getString())));
                return 0;
            }
            BattleRegistry br = Cobblemon.INSTANCE.getBattleRegistry();
            if (br.getBattleByParticipatingPlayer(challengerPlayer) != null) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot send challenge while in-battle"));
                return 0;
            }
            if (Cobblemon.INSTANCE.getStorage().getParty(challengerPlayer).occupied() < format.getTotalPokemonSelected()) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You don't have enough pokemon for this format!"));
                return 0;
            }
            if (Cobblemon.INSTANCE.getStorage().getParty(challengerPlayer).occupied() == 0) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot send challenge while you have no pokemon!"));
                return 0;
            }
            float distance = challengedPlayer.method_5739((class_1297)challengerPlayer);
            if (USE_DISTANCE_RESTRICTION && (distance > MAX_DISTANCE || challengedPlayer.method_37908() != challengerPlayer.method_37908())) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)String.format("Target must be less than %d blocks away to initiate a challenge", (int)MAX_DISTANCE)));
                return 0;
            }
            if (challengerPlayer == challengedPlayer) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You may not challenge yourself"));
                return 0;
            }
            class_2561 errorMessage = CobblemonChallenge.TEAM_VALIDATOR.validateTeam(Cobblemon.INSTANCE.getStorage().getParty(challengerPlayer));
            if (errorMessage != null) {
                ((class_2168)c.getSource()).method_9213(errorMessage);
                return 0;
            }
            ChallengeRequest request = ChallengeUtil.createChallengeRequest(challengerPlayer, challengedPlayer, level, preview, format);
            CHALLENGE_REQUESTS.put(request.id, request);
            Object options = "";
            if (!request.preview()) {
                options = String.valueOf(class_124.field_1065) + " [NoTeamPreview]";
            }
            class_5250 notificationComponent = class_2561.method_43470((String)(String.valueOf(class_124.field_1054) + String.format("You have been challenged to a " + String.valueOf(class_124.field_1067) + "level %d %s Pokemon battle" + String.valueOf(class_124.field_1070) + String.valueOf(class_124.field_1054) + " by %s!" + (String)options, level, request.format.getTitle(), challengerPlayer.method_5476().getString())));
            class_5250 interactiveComponent = class_2561.method_43470((String)"Click to accept or deny: ");
            interactiveComponent.method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + "Battle!")).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/acceptchallenge %s", request.id)))));
            interactiveComponent.method_10852((class_2561)class_2561.method_43470((String)" or "));
            interactiveComponent.method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + "Reject")).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/rejectchallenge %s", request.id)))));
            challengedPlayer.method_7353((class_2561)notificationComponent, false);
            challengedPlayer.method_7353((class_2561)interactiveComponent, false);
            challengerPlayer.method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1054) + String.format("Challenge has been sent to %s", challengedPlayer.method_5476().getString()))), false);
            LAST_SENT_CHALLENGE.put(challengerPlayer.method_5667(), System.currentTimeMillis());
            return 1;
        }
        catch (Exception e) {
            ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("An unexpected error has occurred: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    public static int rejectChallenge(CommandContext<class_2168> c, String challengeId) {
        try {
            ChallengeRequest request = CHALLENGE_REQUESTS.get(challengeId);
            if (request == null) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Challenge request is not valid"));
                return 0;
            }
            CHALLENGE_REQUESTS.remove(request.id);
            request.challengedPlayer.method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + "Challenge has been rejected")), false);
            if (ChallengeUtil.isPlayerOnline(request.challengerPlayer)) {
                request.challengerPlayer.method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + String.format("%s has rejected your challenge.", request.challengedPlayer.method_5476().getString()))), false);
            }
            return 1;
        }
        catch (Exception e) {
            ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("An unexpected error has occurred: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    public static int acceptChallenge(CommandContext<class_2168> c, String challengeId) {
        try {
            ChallengeRequest request = CHALLENGE_REQUESTS.get(challengeId);
            if (request == null) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Challenge request is not valid"));
                return 0;
            }
            BattleRegistry br = Cobblemon.INSTANCE.getBattleRegistry();
            if (br.getBattleByParticipatingPlayer(request.challengedPlayer) != null) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot accept challenge: you are already in a battle"));
                return 0;
            }
            if (br.getBattleByParticipatingPlayer(request.challengerPlayer) != null) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)String.format("Cannot accept challenge: %s is already in a battle", request.challengerPlayer.method_5476().getString())));
                return 0;
            }
            if (Cobblemon.INSTANCE.getStorage().getParty(request.challengedPlayer).occupied() == 0) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot accept challenge: You have no pokemon!"));
                return 0;
            }
            if (Cobblemon.INSTANCE.getStorage().getParty(request.challengerPlayer).occupied() == 0) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)String.format("Cannot accept challenge: %s has no pokemon... somehow!", request.challengerPlayer.method_5476().getString())));
                return 0;
            }
            if (Cobblemon.INSTANCE.getStorage().getParty(request.challengedPlayer).occupied() < request.format.getTotalPokemonSelected()) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot accept challenge: You don't have enough pokemon for this format!"));
                return 0;
            }
            float distance = request.challengerPlayer.method_5739((class_1297)request.challengedPlayer);
            if (USE_DISTANCE_RESTRICTION && (distance > MAX_DISTANCE || request.challengerPlayer.method_37908() != request.challengedPlayer.method_37908())) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)String.format("Target must be less than %d blocks away to accept a challenge", (int)MAX_DISTANCE)));
                return 0;
            }
            ChallengeRequest challengeRequestRemoved = CHALLENGE_REQUESTS.remove(challengeId);
            class_3222 challengerPlayer = request.challengerPlayer;
            if (!ChallengeUtil.isPlayerOnline(challengerPlayer)) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)String.format("%s is no longer online", challengerPlayer.method_5476().getString())));
                return 0;
            }
            class_2561 challengedPlayerError = CobblemonChallenge.TEAM_VALIDATOR.validateTeam(Cobblemon.INSTANCE.getStorage().getParty(request.challengedPlayer));
            if (challengedPlayerError != null) {
                ((class_2168)c.getSource()).method_9213(challengedPlayerError);
                return 0;
            }
            class_2561 challengerPlayerError = CobblemonChallenge.TEAM_VALIDATOR.validateTeam(Cobblemon.INSTANCE.getStorage().getParty(challengerPlayer));
            if (challengerPlayerError != null) {
                challengerPlayer.method_43496(challengerPlayerError);
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot start the fight, your opponent is breaking the rules!").method_27692(class_124.field_1061));
                return 0;
            }
            ChallengeCommand.setupLeadPokemonFlow(challengeRequestRemoved);
            return 1;
        }
        catch (Exception exc) {
            ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unexpected exception when accepting challenge: " + exc.getMessage())));
            exc.printStackTrace();
            return 1;
        }
    }

    private static void setupLeadPokemonFlow(ChallengeRequest request) {
        UUID selectionId = UUID.randomUUID();
        long creationTime = System.currentTimeMillis();
        LeadPokemonSelectionSession selectionWrapper = new LeadPokemonSelectionSession(selectionId, creationTime, request);
        ACTIVE_SELECTIONS.put(selectionId, new LeadPokemonSelection(selectionWrapper, creationTime));
        selectionWrapper.openPlayerMenus();
    }

    public record ChallengeRequest(String id, class_3222 challengerPlayer, class_3222 challengedPlayer, int level, boolean preview, long createdTime, ChallengeFormat format) {
    }

    public record LeadPokemonSelection(LeadPokemonSelectionSession selectionWrapper, long createdTime) {
    }
}

