/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.turtlehoarder.cobblemonchallenge.common.CobblemonChallenge;
import com.turtlehoarder.cobblemonchallenge.common.battle.ChallengeBattleBuilder;
import com.turtlehoarder.cobblemonchallenge.common.command.ChallengeCommand;
import com.turtlehoarder.cobblemonchallenge.common.gui.LeadPokemonSelectionSession;
import com.turtlehoarder.cobblemonchallenge.common.util.ChallengeUtil;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ChallengeEventHandler {
    public static void registerEvents() {
        ChallengeEventHandler.registerPostVictoryEvent();
        ChallengeEventHandler.registerCobblemonSavePrevention();
        PlayerEvent.PLAYER_QUIT.register(ChallengeEventHandler::onPlayerLoggedOut);
        TickEvent.SERVER_POST.register(ChallengeEventHandler::onServerTick);
    }

    public static boolean registerPostVictoryEvent() {
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, battleVictoryEvent -> {
            UUID battleId = battleVictoryEvent.getBattle().getBattleId();
            if (ChallengeUtil.isBattleChallenge(battleId)) {
                PokemonBattle battle = battleVictoryEvent.getBattle();
                ArrayList participants = new ArrayList(battle.getPlayers());
                ListIterator participantIterator = participants.listIterator();
                while (participantIterator.hasNext()) {
                    class_3222 player = (class_3222)participantIterator.next();
                    for (BattleActor actor : battleVictoryEvent.getWinners()) {
                        actor.getPlayerUUIDs().forEach(winnerUUID -> {
                            if (player.method_5667().equals(winnerUUID)) {
                                player.method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + "You have won the challenge!")), false);
                                participantIterator.remove();
                            }
                        });
                    }
                }
                participants.forEach(loser -> loser.method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + "You have lost the challenge")), false));
            }
            Iterator<PokemonBattle> challengeBattleIterator = ChallengeBattleBuilder.challengeBattles.iterator();
            while (challengeBattleIterator.hasNext()) {
                PokemonBattle battle = challengeBattleIterator.next();
                if (!battle.getBattleId().equals(battleVictoryEvent.getBattle().getBattleId())) continue;
                challengeBattleIterator.remove();
                CobblemonChallenge.LOGGER.debug(String.format("Removing tracked Challenge battle id: %s", battleVictoryEvent.getBattle().getBattleId()));
            }
            return Unit.INSTANCE;
        });
        return true;
    }

    private static void registerCobblemonSavePrevention() {
        CobblemonEvents.POKEMON_ENTITY_SAVE_TO_WORLD.subscribe(Priority.HIGHEST, saveEvent -> {
            PokemonEntity pokemonEntity = saveEvent.getPokemonEntity();
            if (ChallengeUtil.isPokemonPartOfChallenge(pokemonEntity)) {
                CobblemonChallenge.LOGGER.debug(String.format(String.format("Cancelling save event for challenge-mon: %s", pokemonEntity.method_5476().getString()), new Object[0]));
                saveEvent.cancel();
            }
            return Unit.INSTANCE;
        });
    }

    public static void onPlayerLoggedOut(class_3222 serverPlayer) {
        Iterator<PokemonBattle> battleIterator = ChallengeBattleBuilder.challengeBattles.iterator();
        while (battleIterator.hasNext()) {
            PokemonBattle battle = battleIterator.next();
            if (!battle.getPlayers().contains(serverPlayer)) continue;
            CobblemonChallenge.LOGGER.debug(String.format("Found hanging battle! (%s)", battle.getBattleId()));
            battleIterator.remove();
        }
    }

    public static void onServerTick(MinecraftServer server) {
        int tickCount = server.method_3780();
        if (tickCount % 20 == 0) {
            long nowTime = System.currentTimeMillis();
            Iterator<Map.Entry<String, ChallengeCommand.ChallengeRequest>> requestIterator = ChallengeCommand.CHALLENGE_REQUESTS.entrySet().iterator();
            while (requestIterator.hasNext()) {
                Map.Entry<String, ChallengeCommand.ChallengeRequest> requestMap = requestIterator.next();
                ChallengeCommand.ChallengeRequest request = requestMap.getValue();
                if (request.createdTime() + (long)CobblemonChallenge.REQUEST_EXPIRATION_MILLIS >= nowTime) continue;
                if (ChallengeUtil.isPlayerOnline(request.challengedPlayer())) {
                    request.challengedPlayer().method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + String.format("Challenge from %s has expired", request.challengerPlayer().method_5476().getString()))), false);
                }
                if (ChallengeUtil.isPlayerOnline(request.challengerPlayer())) {
                    request.challengerPlayer().method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + String.format("Challenge to %s has expired", request.challengedPlayer().method_5476().getString()))), false);
                }
                requestIterator.remove();
            }
            Iterator<Map.Entry<UUID, ChallengeCommand.LeadPokemonSelection>> selectionIterator = ChallengeCommand.ACTIVE_SELECTIONS.entrySet().iterator();
            while (selectionIterator.hasNext()) {
                LeadPokemonSelectionSession selectionSession = selectionIterator.next().getValue().selectionWrapper();
                selectionSession.doTick();
                if (selectionSession.creationTime + (long)LeadPokemonSelectionSession.LEAD_TIMEOUT_MILLIS >= nowTime) continue;
                selectionSession.timeoutRequest();
                selectionIterator.remove();
            }
            Iterator<LeadPokemonSelectionSession> cancelSessions = LeadPokemonSelectionSession.SESSIONS_TO_CANCEL.iterator();
            while (cancelSessions.hasNext()) {
                LeadPokemonSelectionSession session = cancelSessions.next();
                ChallengeCommand.ACTIVE_SELECTIONS.remove(session.getUuid());
                cancelSessions.remove();
            }
        }
    }
}

