/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common.gui;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.turtlehoarder.cobblemonchallenge.common.battle.ChallengeFormat;
import com.turtlehoarder.cobblemonchallenge.common.command.ChallengeCommand;
import com.turtlehoarder.cobblemonchallenge.common.gui.LeadPokemonMenu;
import com.turtlehoarder.cobblemonchallenge.common.gui.LeadPokemonSelectionSession;
import com.turtlehoarder.cobblemonchallenge.common.gui.LeadPokemonStaticMappings;
import com.turtlehoarder.cobblemonchallenge.common.util.ChallengeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeadPokemonMenuProvider
implements class_3908 {
    private final class_3222 selector;
    private final class_3222 rival;
    private PartyStore p1Party;
    private int rivalSelectedPokemon = 0;
    private final LeadPokemonSelectionSession selectionSession;
    private boolean guiModifierFlag = false;
    private MenuState menuState = MenuState.WAITING_FOR_BOTH;
    private LeadPokemonMenu openedMenu;
    public List<Integer> selectedSlots = new ArrayList<Integer>();
    private ChallengeCommand.ChallengeRequest request;

    public LeadPokemonMenuProvider(LeadPokemonSelectionSession wrapper, class_3222 selector, class_3222 rivalPlayer, ChallengeCommand.ChallengeRequest request) {
        this.selector = selector;
        this.rival = rivalPlayer;
        this.selectionSession = wrapper;
        this.request = request;
    }

    @NotNull
    public class_2561 method_5476() {
        if (this.request.format().getTotalPokemonSelected() == 1) {
            return class_2561.method_43470((String)"Select your Lead Pokemon");
        }
        return class_2561.method_43470((String)"Select %d Pokemon for %s".formatted(this.request.format().getTotalPokemonSelected(), this.request.format().getTitle()));
    }

    @Nullable
    public class_1703 createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer) {
        LeadPokemonMenu leadPokemonMenu = new LeadPokemonMenu(this, pContainerId, pPlayerInventory);
        this.setupPokemonRepresentation(leadPokemonMenu);
        this.openedMenu = leadPokemonMenu;
        return leadPokemonMenu;
    }

    private void setupPokemonRepresentation(LeadPokemonMenu leadPokemonMenu) {
        Pokemon pokemon;
        int itemSlot;
        int x;
        this.p1Party = Cobblemon.INSTANCE.getStorage().getParty(this.selector);
        PlayerPartyStore p2Party = Cobblemon.INSTANCE.getStorage().getParty(this.rival);
        this.setupGlassFiller(leadPokemonMenu);
        for (x = 0; x < this.p1Party.size(); ++x) {
            itemSlot = x * 9;
            pokemon = this.p1Party.get(x);
            if (pokemon == null) continue;
            BattlePokemon copy = BattlePokemon.Companion.safeCopyOf(pokemon);
            pokemon = ChallengeUtil.applyFormatTransformations(ChallengeFormat.STANDARD_6V6, copy, this.request.level()).getEffectedPokemon();
            class_1799 pokemonItem = PokemonItem.from((Pokemon)pokemon, (int)1);
            pokemonItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(String.valueOf(class_124.field_1075) + String.format("%s (lvl%d)", pokemon.getDisplayName().getString(), this.request.level()))));
            class_9290 pokemonLoreTag = ChallengeUtil.generateLoreTagForPokemon(pokemon);
            pokemonItem.method_57379(class_9334.field_49632, (Object)pokemonLoreTag);
            leadPokemonMenu.method_7619(itemSlot, leadPokemonMenu.method_37421(), pokemonItem);
        }
        for (x = 0; x < p2Party.size(); ++x) {
            class_1799 pokemonItem;
            itemSlot = x * 9 + 8;
            pokemon = p2Party.get(x);
            if (pokemon == null) continue;
            if (this.selectionSession.teamPreviewOn()) {
                pokemonItem = PokemonItem.from((Pokemon)pokemon, (int)1);
                pokemonItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + String.format("%s's %s (lvl%d)", this.rival.method_5476().getString(), pokemon.getDisplayName().getString(), this.request.level()))));
                leadPokemonMenu.method_7619(itemSlot, leadPokemonMenu.method_37421(), pokemonItem);
                continue;
            }
            pokemonItem = new class_1799((class_1935)CobblemonItems.POKE_BALL.method_8389());
            pokemonItem.method_57379(class_9334.field_49638, (Object)class_3902.field_17274);
            pokemonItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + String.format("%s's Pokemon", this.rival.method_5476().getString()))));
            leadPokemonMenu.method_7619(itemSlot, leadPokemonMenu.method_37421(), pokemonItem);
        }
    }

    private void setGlassDisplayName(class_1799 s, int secondsLeft) {
        s.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(String.valueOf(class_124.field_1075) + String.format("Seconds left to choose: %d", secondsLeft))));
        class_9290 glassLoreTag = this.generateLoreTagForGlass(s);
        s.method_57379(class_9334.field_49632, (Object)glassLoreTag);
    }

    private class_9290 generateLoreTagForGlass(class_1799 s) {
        ArrayList<class_5250> components = new ArrayList<class_5250>();
        class_5250 additionalInformation = this.menuState == MenuState.WAITING_FOR_RIVAL ? class_2561.method_43470((String)(String.valueOf(class_124.field_1068) + String.format("Waiting on %s...", this.rival.method_5476().getString()))) : (this.menuState == MenuState.WAITING_FOR_PLAYER ? (this.request.format().getTotalPokemonSelected() == 1 ? class_2561.method_43470((String)(String.valueOf(class_124.field_1068) + "Waiting on you to select Lead...")) : class_2561.method_43470((String)(String.valueOf(class_124.field_1068) + "Waiting on you to select %d pokemon...".formatted(this.request.format().getTotalPokemonSelected())))) : class_2561.method_43470((String)(String.valueOf(class_124.field_1068) + "Waiting on both players to select leads...")));
        components.add(additionalInformation);
        return new class_9290(components);
    }

    private void setupGlassFiller(LeadPokemonMenu leadPokemonMenu) {
        int timeLeft = (int)Math.ceil((float)(this.selectionSession.creationTime + (long)LeadPokemonSelectionSession.LEAD_TIMEOUT_MILLIS - System.currentTimeMillis()) / 1000.0f);
        for (int column = 1; column <= 7; ++column) {
            for (int row = 0; row < 6; ++row) {
                int itemSlot = row * 9 + column;
                class_1799 itemFiller = column == 1 ? ((row + (this.guiModifierFlag ? 0 : 1)) % 2 == 0 || this.menuState == MenuState.WAITING_FOR_RIVAL ? new class_1799((class_1935)class_1802.field_8581) : new class_1799((class_1935)class_1802.field_8656)) : (column == 7 ? ((row + (this.guiModifierFlag ? 0 : 1)) % 2 == 0 || this.menuState == MenuState.WAITING_FOR_PLAYER ? new class_1799((class_1935)class_1802.field_8500) : new class_1799((class_1935)class_1802.field_8879)) : new class_1799((class_1935)class_1802.field_8871));
                this.setGlassDisplayName(itemFiller, timeLeft);
                leadPokemonMenu.method_7619(itemSlot, leadPokemonMenu.method_37421(), itemFiller);
            }
        }
    }

    private void setupPokemonSelection(LeadPokemonMenu leadPokemonMenu) {
        int timeLeft = (int)Math.ceil((float)(this.selectionSession.creationTime + (long)LeadPokemonSelectionSession.LEAD_TIMEOUT_MILLIS - System.currentTimeMillis()) / 1000.0f);
        if (this.request.format().getTotalPokemonSelected() == 1) {
            if (!this.selectedSlots.isEmpty()) {
                Pokemon selectedPokemon = this.p1Party.get(this.selectedSlots.getFirst().intValue());
                class_1799 glassFiller = new class_1799(ChallengeUtil.getDisplayBlockForPokemon(selectedPokemon));
                this.setGlassDisplayName(glassFiller, timeLeft);
                leadPokemonMenu.setItemSlotMulti(glassFiller, 12, 30, 20);
                class_1799 pokemonFiller = PokemonItem.from((Pokemon)selectedPokemon, (int)1);
                pokemonFiller.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + String.format("You've selected %s as your lead", selectedPokemon.getDisplayName().getString()))));
                leadPokemonMenu.method_7619(21, leadPokemonMenu.method_37421(), pokemonFiller);
            }
            if (this.rivalSelectedPokemon == this.selectionSession.getMaxPokemonSelection()) {
                class_1799 glassFiller = new class_1799((class_1935)class_2246.field_9991);
                this.setGlassDisplayName(glassFiller, timeLeft);
                leadPokemonMenu.setItemSlotMulti(glassFiller, 23, 13, 31);
                class_1799 pokeballFiller = new class_1799((class_1935)CobblemonItems.POKE_BALL.method_8389());
                pokeballFiller.method_57379(class_9334.field_49638, (Object)class_3902.field_17274);
                pokeballFiller.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + String.format("%s has selected their lead", this.rival.method_5476().getString()))));
                leadPokemonMenu.method_7619(22, leadPokemonMenu.method_37421(), pokeballFiller);
            }
        } else {
            Map<Integer, Integer> allySlotMap = LeadPokemonStaticMappings.getPositionAllyMap(this.request);
            Map<Integer, Integer> rivalSlotMap = LeadPokemonStaticMappings.getPositionRivalMap(this.request);
            for (int rivalSelectedNumber = 0; rivalSelectedNumber < this.rivalSelectedPokemon; ++rivalSelectedNumber) {
                class_1799 pokeballFiller = new class_1799((class_1935)CobblemonItems.POKE_BALL.method_8389());
                pokeballFiller.method_57379(class_9334.field_49638, (Object)class_3902.field_17274);
                pokeballFiller.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + String.format("%s has selected Pokemon #" + (rivalSelectedNumber + 1), this.rival.method_5476().getString()))));
                leadPokemonMenu.method_7619(rivalSlotMap.get(rivalSelectedNumber + 1), leadPokemonMenu.method_37421(), pokeballFiller);
            }
            for (int selectedNumber = 0; selectedNumber < this.selectedSlots.size(); ++selectedNumber) {
                Pokemon selectedPokemon = this.p1Party.get(this.selectedSlots.get(selectedNumber).intValue());
                class_1799 pokemonFiller = PokemonItem.from((Pokemon)selectedPokemon, (int)1);
                pokemonFiller.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + String.format("You've selected %s as Pokemon #" + (selectedNumber + 1), selectedPokemon.getDisplayName().getString()))));
                ArrayList<class_5250> components = new ArrayList<class_5250>();
                if (selectedNumber == 0 && this.request.format().getBattleType().getSlotsPerActor() == 1) {
                    components.add(class_2561.method_43470((String)String.format(String.valueOf(class_124.field_1065) + "This is your lead", new Object[0])));
                }
                if (this.selectedSlots.size() < this.request.format().getTotalPokemonSelected()) {
                    components.add(class_2561.method_43470((String)String.format(String.valueOf(class_124.field_1054) + "Click to unselect pokemmon", new Object[0])));
                }
                pokemonFiller.method_57379(class_9334.field_49632, (Object)new class_9290(components));
                leadPokemonMenu.method_7619(allySlotMap.get(selectedNumber + 1), leadPokemonMenu.method_37421(), pokemonFiller);
            }
            class_1799 lockinGlassFillerAlly = new class_1799((class_1935)class_2246.field_9991);
            class_1799 lockinGlassFillerRival = new class_1799((class_1935)class_2246.field_9991);
            this.setGlassDisplayName(lockinGlassFillerAlly, timeLeft);
            this.setGlassDisplayName(lockinGlassFillerRival, timeLeft);
            if (this.isLockedIn()) {
                leadPokemonMenu.setItemSlotMulti(lockinGlassFillerAlly, LeadPokemonStaticMappings.getLockinGlassPositionAlly(this.request));
            }
            if (this.isRivalLockedIn()) {
                leadPokemonMenu.setItemSlotMulti(lockinGlassFillerRival, LeadPokemonStaticMappings.getLockinGlassPositionRival(this.request));
            }
        }
    }

    protected void onGeneralMenuClick(LeadPokemonMenu menu, int pSlotId) {
        Map<Integer, Integer> allyMap = LeadPokemonStaticMappings.getPositionAllyMap(this.request);
        Collection<Integer> possiblePositions = allyMap.values();
        if (possiblePositions != null && possiblePositions.contains(pSlotId) && this.selectedSlots.size() < this.request.format().getTotalPokemonSelected()) {
            int selectedSlot = -1;
            for (Map.Entry<Integer, Integer> entry : allyMap.entrySet()) {
                int slot = entry.getKey();
                int menuSlot = entry.getValue();
                if (menuSlot != pSlotId) continue;
                selectedSlot = slot;
                break;
            }
            if (selectedSlot != -1 && selectedSlot <= this.selectedSlots.size()) {
                this.selectedSlots.remove(selectedSlot - 1);
                this.refreshInnerGuiItems();
                this.selectionSession.onPokemonUnselected(this);
            }
        }
    }

    protected void onSelectPokemonSlot(LeadPokemonMenu menu, int slotId) {
        Pokemon selectedPokemon;
        if (this.selectedSlots.size() < this.selectionSession.getMaxPokemonSelection() && (selectedPokemon = this.p1Party.get(slotId)) != null && !this.selectedSlots.contains(slotId)) {
            this.selectedSlots.add(slotId);
            this.refreshInnerGuiItems();
            this.selectionSession.onPokemonSelected(this);
            this.updateMenuState();
        }
    }

    private void refreshInnerGuiItems() {
        this.setupGlassFiller(this.openedMenu);
        this.setupPokemonSelection(this.openedMenu);
    }

    public void timedGuiUpdate() {
        this.guiModifierFlag = !this.guiModifierFlag;
        this.refreshInnerGuiItems();
    }

    public void forceCloseMenu() {
        if (this.openedMenu != null) {
            this.openedMenu.invalidateMenu();
        }
    }

    protected void onPlayerCloseContainer() {
        this.selectionSession.onPlayerCloseMenu(this.selector);
    }

    private void updateMenuState() {
        this.menuState = this.rivalSelectedPokemon == this.selectionSession.getMaxPokemonSelection() && this.selectedSlots.size() < this.selectionSession.getMaxPokemonSelection() ? MenuState.WAITING_FOR_PLAYER : (this.selectedSlots.size() == this.selectionSession.getMaxPokemonSelection() && this.rivalSelectedPokemon < this.selectionSession.getMaxPokemonSelection() ? MenuState.WAITING_FOR_RIVAL : MenuState.WAITING_FOR_BOTH);
    }

    public void updateRivalCount(int newCount) {
        this.rivalSelectedPokemon = newCount;
        this.updateMenuState();
    }

    private boolean isRivalLockedIn() {
        return this.rivalSelectedPokemon == this.request.format().getTotalPokemonSelected();
    }

    private boolean isLockedIn() {
        return this.selectedSlots.size() == this.request.format().getTotalPokemonSelected();
    }

    private static enum MenuState {
        WAITING_FOR_BOTH,
        WAITING_FOR_RIVAL,
        WAITING_FOR_PLAYER;

    }
}

