/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common.util;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.turtlehoarder.cobblemonchallenge.common.battle.ChallengeBattleBuilder;
import com.turtlehoarder.cobblemonchallenge.common.battle.ChallengeFormat;
import com.turtlehoarder.cobblemonchallenge.common.command.ChallengeCommand;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9290;

public class ChallengeUtil {
    public static boolean isPokemonPartOfChallenge(PokemonEntity pokemonEntity) {
        if (!pokemonEntity.isBattling() || pokemonEntity.getBattleId() == null) {
            return false;
        }
        UUID battleId = pokemonEntity.getBattleId();
        for (PokemonBattle battle : ChallengeBattleBuilder.challengeBattles) {
            if (!battleId.equals(battle.getBattleId())) continue;
            return true;
        }
        return false;
    }

    public static PokemonBattle getAssociatedBattle(PokemonEntity pokemonEntity) {
        if (!pokemonEntity.isBattling() || pokemonEntity.getBattleId() == null) {
            return null;
        }
        UUID battleId = pokemonEntity.getBattleId();
        for (PokemonBattle battle : ChallengeBattleBuilder.challengeBattles) {
            if (!battleId.equals(battle.getBattleId())) continue;
            return battle;
        }
        return null;
    }

    public static boolean isBattleChallenge(UUID battleId) {
        return ChallengeBattleBuilder.challengeBattles.stream().anyMatch(battle -> battle.getBattleId().equals(battleId));
    }

    public static boolean isPlayerOnline(class_3222 player) {
        return player.method_5682().method_3760().method_14602(player.method_5667()) != null;
    }

    public static ChallengeCommand.ChallengeRequest createChallengeRequest(class_3222 challengerPlayer, class_3222 challengedPlayer, int level, boolean preview, ChallengeFormat format) {
        String key = UUID.randomUUID().toString().replaceAll("-", "");
        return new ChallengeCommand.ChallengeRequest(key, challengerPlayer, challengedPlayer, level, preview, System.currentTimeMillis(), format);
    }

    public static class_1935 getDisplayBlockForPokemon(Pokemon pokemon) {
        ElementalType type = pokemon.getPrimaryType();
        return switch (type.getName()) {
            case "normal" -> class_2246.field_9991;
            case "fire" -> class_2246.field_10118;
            case "water", "dragon" -> class_2246.field_9982;
            case "grass" -> class_1802.field_8256;
            case "electric" -> class_2246.field_10578;
            case "ice" -> class_2246.field_10355;
            case "fighting" -> class_1802.field_8879;
            case "poison" -> class_2246.field_10152;
            case "ground" -> class_2246.field_10163;
            case "flying" -> class_1802.field_8153;
            case "psychic" -> class_2246.field_10469;
            case "bug" -> class_1802.field_8786;
            case "rock" -> class_2246.field_10445;
            case "ghost", "dark" -> class_2246.field_9997;
            case "steel" -> class_2246.field_10576;
            case "fairy" -> class_2246.field_10565;
            default -> class_2246.field_10285;
        };
    }

    public static class_9290 generateLoreTagForPokemon(Pokemon pokemon) {
        ArrayList<class_5250> components = new ArrayList<class_5250>();
        class_5250 abilityComponent = class_2561.method_43470((String)String.format(String.valueOf(class_124.field_1080) + "Ability: %s", String.valueOf(class_124.field_1054) + LocalizationUtilsKt.lang((String)String.format("ability.%s", pokemon.getAbility().getName()), (Object[])new Object[0]).getString()));
        String natureKey = pokemon.getNature().getName().method_42094();
        class_5250 natureComponent = class_2561.method_43470((String)String.format(String.valueOf(class_124.field_1080) + "Nature: %s", String.valueOf(class_124.field_1054) + LocalizationUtilsKt.lang((String)String.format("nature.%s", natureKey.substring(natureKey.lastIndexOf(46) + 1)), (Object[])new Object[0]).getString()));
        String statSeparator = String.valueOf(class_124.field_1080) + " / ";
        class_5250 statsPartOne = class_2561.method_43470((String)String.format(String.valueOf(class_124.field_1061) + "HP: %d" + statSeparator + String.valueOf(class_124.field_1065) + "Atk: %d" + statSeparator + String.valueOf(class_124.field_1054) + "Def: %d", pokemon.getHp(), pokemon.getAttack(), pokemon.getDefence()));
        class_5250 statsPartTwo = class_2561.method_43470((String)String.format(String.valueOf(class_124.field_1075) + "SpA: %d" + statSeparator + String.valueOf(class_124.field_1060) + "SpD: %d" + statSeparator + String.valueOf(class_124.field_1076) + "Spe: %d", pokemon.getSpecialAttack(), pokemon.getSpecialDefence(), pokemon.getSpeed()));
        class_5250 moveSeperator = class_2561.method_43470((String)"Moves:");
        components.add(abilityComponent);
        components.add(natureComponent);
        components.add(statsPartOne);
        components.add(statsPartTwo);
        components.add(moveSeperator);
        pokemon.getMoveSet().getMoves().forEach(move -> {
            class_5250 moveComponent = class_2561.method_43470((String)(String.valueOf(class_124.field_1068) + String.format("%s - %d/%d", move.getDisplayName().getString() + String.valueOf(class_124.field_1080), move.getMaxPp(), move.getMaxPp())));
            components.add(moveComponent);
        });
        return new class_9290(components);
    }

    public static UUID getOwnerUuidOfClonedPokemon(PokemonBattle battle, PokemonEntity pokemonEntity) {
        for (ActiveBattlePokemon abp : battle.getActivePokemon()) {
            if (abp.getBattlePokemon() == null || !pokemonEntity.getPokemon().getUuid().equals(abp.getBattlePokemon().getEffectedPokemon().getUuid())) continue;
            return abp.getBattlePokemon().getOriginalPokemon().getOwnerUUID();
        }
        return null;
    }

    public static BattlePokemon applyFormatTransformations(ChallengeFormat format, BattlePokemon pokemon, int level) {
        if (format == ChallengeFormat.STANDARD_6V6) {
            pokemon.getEffectedPokemon().setLevel(level);
            pokemon.getEffectedPokemon().heal();
        }
        return pokemon;
    }

    public static int getBattlePokemonAdjustedLevel(int actualLevel, int minLevel, int maxLevel, int handicap) {
        int adjustedLevel = actualLevel < minLevel ? minLevel + handicap : Math.min(actualLevel, maxLevel) + handicap;
        return adjustedLevel < 1 ? 1 : Math.min(adjustedLevel, 100);
    }
}

