/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common.validation;

import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.mojang.datafixers.util.Pair;
import com.turtlehoarder.cobblemonchallenge.common.CobblemonChallenge;
import com.turtlehoarder.cobblemonchallenge.common.validation.PokemonValidator;
import com.turtlehoarder.cobblemonchallenge.common.validation.TeamValidator;
import com.turtlehoarder.cobblemonchallenge.common.validation.validators.BlacklistValidator;
import com.turtlehoarder.cobblemonchallenge.common.validation.validators.DexRangeValidator;
import com.turtlehoarder.cobblemonchallenge.common.validation.validators.DuplicateSpeciesValidator;
import com.turtlehoarder.cobblemonchallenge.common.validation.validators.TeamCounterValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ChallengeTeamValidator {
    private final List<PokemonValidator> pokemonValidators = new ArrayList<PokemonValidator>();
    private final List<TeamValidator> teamValidators = new ArrayList<TeamValidator>();
    private final BiFunction<String, String, String> stringGetter;
    private final BiFunction<String, Integer, Integer> intGetter;
    private final BiFunction<String, Boolean, Boolean> booleanGetter;
    private final boolean debug;
    public static final List<Pair<String, String>> DEFAULT_CONFIG_VALUES = List.of(Pair.of((Object)"bannedSpecies", (Object)"[]"), Pair.of((Object)"bannedAbilities", (Object)"[]"), Pair.of((Object)"bannedMoves", (Object)"[]"), Pair.of((Object)"bannedForms", (Object)"[]"), Pair.of((Object)"bannedWorlds", (Object)"[]"));
    public static final List<Pair<String, Integer>> DEFAULT_INTEGER_CONFIG_VALUES = List.of(Pair.of((Object)"minDex", (Object)Integer.MIN_VALUE), Pair.of((Object)"maxDex", (Object)Integer.MAX_VALUE), Pair.of((Object)"maxLegendaries", (Object)Integer.MAX_VALUE), Pair.of((Object)"maxBeasts", (Object)Integer.MAX_VALUE));
    public static final List<Pair<String, Boolean>> DEFAULT_BOOLEAN_CONFIG_VALUES = List.of(Pair.of((Object)"banDuplicateSpecies", (Object)false));

    public ChallengeTeamValidator(BiFunction<String, String, String> stringGetter, BiFunction<String, Integer, Integer> intGetter, BiFunction<String, Boolean, Boolean> booleanGetter, boolean debug) {
        this.stringGetter = stringGetter;
        this.intGetter = intGetter;
        this.booleanGetter = booleanGetter;
        this.debug = debug;
    }

    public void onServerStart() {
        if (this.pokemonValidators.size() > 0) {
            return;
        }
        CobblemonChallenge.LOGGER.info("Team validator started parsing config");
        this.maybePrintRegistry("species", PokemonSpecies.INSTANCE.getSpecies(), Species::getName);
        this.pokemonValidators.add(BlacklistValidator.of("bannedSpecies", Pokemon::getSpecies, arg_0 -> ((PokemonSpecies)PokemonSpecies.INSTANCE).getByName(arg_0), ability -> "The pokemon species " + ability.getName() + " is banned", this.stringGetter));
        this.maybePrintRegistry("abilities", Abilities.INSTANCE.all(), AbilityTemplate::getName);
        this.pokemonValidators.add(BlacklistValidator.of("bannedAbilities", pokemon -> pokemon.getAbility().getTemplate(), arg_0 -> ((Abilities)Abilities.INSTANCE).get(arg_0), ability -> "The ability " + ability.getName() + " is banned", this.stringGetter));
        this.maybePrintRegistry("moves", Moves.INSTANCE.all(), MoveTemplate::getName);
        this.pokemonValidators.add(BlacklistValidator.ofList("bannedMoves", pokemon -> pokemon.getMoveSet().getMoves().stream().map(Move::getTemplate).toList(), arg_0 -> ((Moves)Moves.INSTANCE).getByName(arg_0), move -> "The move " + move.getName() + " is banned", this.stringGetter));
        ArrayList forms = new ArrayList();
        PokemonSpecies.INSTANCE.getSpecies().stream().map(Species::getForms).forEach(pokemonForms -> pokemonForms.forEach(pokemonForm -> forms.add(pokemonForm.getSpecies().getName() + ":" + pokemonForm.getName())));
        this.maybePrintRegistry("forms", forms, string -> string);
        this.pokemonValidators.add(BlacklistValidator.of("bannedForms", Pokemon::getForm, ChallengeTeamValidator::formFromString, form -> "The from " + form.getName() + " of pokemon " + form.getSpecies().getName() + " is banned", this.stringGetter));
        this.pokemonValidators.add(new DexRangeValidator(this.intGetter));
        this.teamValidators.add(new TeamCounterValidator(this.intGetter, "Legendaries", pokemon -> pokemon.isLegendary() || pokemon.isMythical() || pokemon.hasLabels(new String[]{"paradox"})));
        this.teamValidators.add(new TeamCounterValidator(this.intGetter, "Beasts", Pokemon::isUltraBeast));
        if (this.booleanGetter.apply("banDuplicateSpecies", false).booleanValue()) {
            this.teamValidators.add(new DuplicateSpeciesValidator());
        }
        CobblemonChallenge.LOGGER.info("Team validator finished parsing config");
    }

    private static FormData formFromString(String asString) {
        String[] speciesAndForm = asString.split(":");
        if (speciesAndForm.length != 2) {
            CobblemonChallenge.LOGGER.error("Error while parsing the pokemon form '" + asString + "' - incorrect format - the correct format is pokemonName:formName");
            return null;
        }
        Species species = PokemonSpecies.INSTANCE.getByName(speciesAndForm[0]);
        if (species == null) {
            CobblemonChallenge.LOGGER.error("Error while parsing the pokemon form '" + asString + "' - the species '" + speciesAndForm[0] + "' does not exist");
            return null;
        }
        List<FormData> form = species.getForms().stream().filter(formData -> formData.getName().equals(speciesAndForm[1])).toList();
        if (form.size() == 0) {
            CobblemonChallenge.LOGGER.error("Error while parsing the pokemon form '" + asString + "' - the species '" + speciesAndForm[0] + "' does not have a form called '" + speciesAndForm[1] + "'");
            return null;
        }
        if (form.size() > 1) {
            CobblemonChallenge.LOGGER.error("Error while parsing the pokemon form '" + asString + "' - the species '" + speciesAndForm[0] + "' somehow has multiple forms called '" + speciesAndForm[1] + "' (??????)");
            return null;
        }
        return form.getFirst();
    }

    public class_2561 validateTeam(PlayerPartyStore playerParty) {
        if (this.pokemonValidators.size() == 0) {
            throw new RuntimeException("Attempted to validate a team before the team validator was loaded!");
        }
        ArrayList errors = new ArrayList();
        playerParty.forEach(pokemon -> this.pokemonValidators.forEach(validator -> errors.addAll(validator.validate((Pokemon)pokemon))));
        this.teamValidators.forEach(validator -> {
            String error = validator.validate(playerParty);
            if (error != null) {
                errors.add(error);
            }
        });
        if (errors.size() == 0) {
            return null;
        }
        class_5250 errorMessage = class_2561.method_43470((String)"Cannot create, start or accept the challenge, you are breaking the rules!").method_27692(class_124.field_1061);
        for (String error : errors) {
            errorMessage.method_10852((class_2561)class_2561.method_43470((String)("\n" + error)).method_27692(class_124.field_1061));
        }
        return errorMessage;
    }

    public String getConfigString(String key, String defaultValue) {
        return this.stringGetter.apply(key, defaultValue);
    }

    private <T> void maybePrintRegistry(String name, Collection<T> registryValues, Function<T, String> toString) {
        if (!this.debug) {
            return;
        }
        CobblemonChallenge.LOGGER.info("All " + name + " (" + registryValues.size() + " entries)");
        registryValues.forEach(toString::apply);
    }
}

