/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common.validation.validators;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.turtlehoarder.cobblemonchallenge.common.CobblemonChallenge;
import com.turtlehoarder.cobblemonchallenge.common.validation.PokemonValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class BlacklistValidator<T>
implements PokemonValidator {
    private final List<T> bannedValues;
    private final Function<T, String> errorMessageFactory;
    private final Function<Pokemon, List<T>> getter;

    private BlacklistValidator(String key, Function<Pokemon, List<T>> getter, Function<String, T> parser, Function<T, String> errorMessageFactory, Function<String, String> valueGetter) {
        this.getter = getter;
        this.errorMessageFactory = errorMessageFactory;
        this.bannedValues = BlacklistValidator.parseList(key, parser, valueGetter.apply(key));
    }

    @Override
    public List<String> validate(Pokemon pokemon) {
        ArrayList<String> errors = new ArrayList<String>();
        List<Object> pokemonValues = this.getter.apply(pokemon);
        pokemonValues.forEach(pokemonValue -> {
            if (this.bannedValues.contains(pokemonValue)) {
                errors.add(this.errorMessageFactory.apply(pokemonValue));
            }
        });
        return errors;
    }

    public static <T> List<T> parseList(String key, Function<String, T> parser, String input) {
        List<String> stringList = BlacklistValidator.parseStringList(key, input);
        ArrayList parsed = new ArrayList();
        stringList.forEach(string -> {
            Object value = parser.apply((String)string);
            if (value == null) {
                CobblemonChallenge.LOGGER.error("Error while parsing " + key + " don't know what is '" + string + "'");
            } else {
                parsed.add(value);
            }
        });
        return parsed;
    }

    private static List<String> parseStringList(String key, String asString) {
        if (!asString.startsWith("[")) {
            CobblemonChallenge.LOGGER.error("Error while parsing " + key + " string list needs to start with [");
        }
        if (!asString.endsWith("]")) {
            CobblemonChallenge.LOGGER.error("Error while parsing " + key + " string list needs to end with ]");
        }
        String[] stringList = asString.substring(1, asString.length() - 1).split(",");
        return Arrays.stream(stringList).map(String::trim).filter(string -> !string.equals("")).toList();
    }

    public static <T> BlacklistValidator<T> of(String key, Function<Pokemon, T> getter, Function<String, T> parser, Function<T, String> errorMessageFactory, BiFunction<String, String, String> valueGetter) {
        return BlacklistValidator.ofList(key, pokemon -> List.of(getter.apply((Pokemon)pokemon)), parser, errorMessageFactory, valueGetter);
    }

    public static <T> BlacklistValidator<T> ofList(String key, Function<Pokemon, List<T>> getter, Function<String, T> parser, Function<T, String> errorMessageFactory, BiFunction<String, String, String> valueGetter) {
        return new BlacklistValidator<T>(key, getter, parser, errorMessageFactory, string -> (String)valueGetter.apply((String)string, "[]"));
    }
}

