/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common.validation.validators;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.turtlehoarder.cobblemonchallenge.common.validation.PokemonValidator;
import java.util.List;
import java.util.function.BiFunction;

public class DexRangeValidator
implements PokemonValidator {
    private final int min;
    private final int max;

    public DexRangeValidator(BiFunction<String, Integer, Integer> intGetter) {
        this.min = intGetter.apply("minDex", Integer.MIN_VALUE);
        this.max = intGetter.apply("maxDex", Integer.MAX_VALUE);
    }

    @Override
    public List<String> validate(Pokemon pokemon) {
        int dexNumber = pokemon.getSpecies().getNationalPokedexNumber();
        if (dexNumber > this.max || dexNumber < this.min) {
            return List.of("Pokedex number " + dexNumber + " of pokemon " + pokemon.getSpecies().getName() + " is not allowed! allowed: " + this.min + "-" + this.max);
        }
        return List.of();
    }
}

